<?php

if ( class_exists( 'TastycPlugin' ) && class_exists( 'OCDI_Plugin' ) ) {

function tastyc_ocdi_import_files() {
    $extra_dir = tastyc_extra_dir();
    if ( $extra_dir == 'normal' ) : return array(); endif;

    return array(
        array(
            'import_file_name'             => 'restaurant',
            'categories'                   => array( esc_attr__( 'Main', 'tastyc' ) ),
            'import_file_url'              => TASTYC_EXTRA_PLUGINS_DIRECTORY . $extra_dir . '/ocdi-import/demo/restaurant/content.xml',
            'import_preview_image_url'     => TASTYC_EXTRA_PLUGINS_DIRECTORY . $extra_dir . '/ocdi-import/demo/restaurant/preview.jpg',
            'preview_url'                  => 'https://1.envato.market/c/1790164/275988/4415?u=https://themeforest.net/item/tastyc-restaurant-wordpress-theme/full_screen_preview/32386289',
        ),

        array(
            'import_file_name'             => 'coffee',
            'categories'                   => array( esc_attr__( 'Main', 'tastyc' ) ),
            'import_file_url'              => TASTYC_EXTRA_PLUGINS_DIRECTORY . $extra_dir . '/ocdi-import/demo/coffee/content.xml',
            'import_preview_image_url'     => TASTYC_EXTRA_PLUGINS_DIRECTORY . $extra_dir . '/ocdi-import/demo/coffee/preview.jpg',
            'preview_url'                  => 'https://1.envato.market/c/1790164/275988/4415?u=https://themeforest.net/item/tastyc-restaurant-wordpress-theme/full_screen_preview/32386289',
        ),

        array(
            'import_file_name'             => 'seafood',
            'categories'                   => array( esc_attr__( 'Main', 'tastyc' ) ),
            'import_file_url'              => TASTYC_EXTRA_PLUGINS_DIRECTORY . $extra_dir . '/ocdi-import/demo/seafood/content.xml',
            'import_preview_image_url'     => TASTYC_EXTRA_PLUGINS_DIRECTORY . $extra_dir . '/ocdi-import/demo/seafood/preview.jpg',
            'preview_url'                  => 'https://1.envato.market/c/1790164/275988/4415?u=https://themeforest.net/item/tastyc-restaurant-wordpress-theme/full_screen_preview/32386289',
        ),

        array(
            'import_file_name'             => 'bar-pub',
            'categories'                   => array( esc_attr__( 'Main', 'tastyc' ) ),
            'import_file_url'              => TASTYC_EXTRA_PLUGINS_DIRECTORY . $extra_dir . '/ocdi-import/demo/bar-pub/content.xml',
            'import_preview_image_url'     => TASTYC_EXTRA_PLUGINS_DIRECTORY . $extra_dir . '/ocdi-import/demo/bar-pub/preview.jpg',
            'preview_url'                  => 'https://1.envato.market/c/1790164/275988/4415?u=https://themeforest.net/item/tastyc-restaurant-wordpress-theme/full_screen_preview/32386289',
        ),
    );
}
add_filter( 'pt-ocdi/import_files', 'tastyc_ocdi_import_files' );

function tastyc_ocdi_after_import_setup( $selected_import ) {
    if ( tastyc_extra_dir() == 'normal' ) : return; endif;

    // Assign menus to their locations.
    $main_menu = get_term_by( 'name', 'Top Menu', 'nav_menu' );

    set_theme_mod( 'nav_menu_locations', array(
            'primary' => $main_menu->term_id,
        )
    );

    // Assign front page and posts page (blog page).
    $front_page_id = get_page_by_title( 'Home' );

    update_option( 'show_on_front', 'page' );
    update_option( 'page_on_front', $front_page_id->ID );
    update_option( 'posts_per_page', 6 );

    $acf_options = array();

    if ( $selected_import['import_file_name'] ) {
      $json = file_get_contents( plugin_dir_path( __FILE__ ) . 'acf-options/' . $selected_import['import_file_name'] . '.json' );
      $json_obj = json_decode( $json, true );
      if ( isset( $json_obj['data'] ) ) {
        $acf_options = $json_obj['data'];
      }
    }

    if ( !empty( $acf_options ) ) {
      global $wpdb;
      foreach ( $acf_options as $item ) {
        if ( $wpdb->get_var( $wpdb->prepare( "SELECT COUNT(*) FROM $wpdb->options WHERE option_name = %s", $item['option_name'] ) ) == 0 ) {
            $wpdb->query( $wpdb->prepare( "INSERT INTO $wpdb->options ( option_name, option_value, autoload ) VALUES (%s, %s, 'no')", $item['option_name'], $item['option_value'] ) );
        } else {
            $wpdb->query( $wpdb->prepare( "UPDATE $wpdb->options SET option_value = %s WHERE option_name = %s", $item['option_value'], $item['option_name'] ) );
        }
      }
    }

}
add_action( 'pt-ocdi/after_import', 'tastyc_ocdi_after_import_setup' );

}
