<?php
/**
 * Template part for displaying posts
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package tastyc
 */

?>

<?php

/* post content */
$current_categories = get_the_terms( get_the_ID(), 'gallery_categories' );
$categories_string = '';
$categories_slugs_string = '';
if ( $current_categories && ! is_wp_error( $current_categories ) ) {
	$arr_keys = array_keys( $current_categories );
	$last_key = end( $arr_keys );
	foreach ( $current_categories as $key => $value ) {
		if ( $key == $last_key ) {
			$categories_string .= $value->name . ' ';
		} else {
			$categories_string .= $value->name . ', ';
		}
		$categories_slugs_string .= 'category-' . $value->slug . ' ';
	}
}

$image = get_the_post_thumbnail_url( get_the_ID(), 'tastyc_950xAuto' );
$image_full = get_the_post_thumbnail_url( get_the_ID(), 'tastyc_1920xAuto' );
$title = get_the_title();
$subtitle = $categories_string;
$show_title = get_query_var( 'show_title' );
$show_category = get_query_var( 'show_category' );

?>

<!-- ItemGallery -->
<div class="col-lg-4 col-md-4 col-sm-6 col-xs-12 itemGallery <?php echo esc_attr( $categories_slugs_string ); ?>">
<div class="itemGallery__box">
	<?php if ( $image ) : ?>
	<a class="itemGallery__link" href="<?php echo esc_url( $image_full ); ?>" data-elementor-lightbox-slideshow="gallery-grid" data-elementor-lightbox-title="<?php echo esc_attr( $title ); ?>" data-size="1920x1080">
		<img class="cover" src="<?php echo esc_url( $image ); ?>" alt="<?php echo esc_attr( $title ); ?>" />
	</a>
	<?php endif; ?>
	<div class="itemGallery__details">
		<?php if ( $subtitle && $show_category ) : ?>
		<span class="tst-text"><?php echo esc_html( $subtitle ); ?></span>
		<?php endif; ?>
		<?php if ( $title && $show_title ) : ?>
		<h5><?php echo esc_html( $title ); ?></h5>
		<?php endif; ?>
	</div>
</div>
</div>
