<?php
/**
 * Template part for displaying reservation openTable form
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package tastyc
 */

?>

<?php

$opentable_id = get_field( 'opentable_id', 'option' );
$opentable_layout = get_field( 'opentable_layout', 'option' );
$opentable_lang = get_field( 'opentable_lang', 'option' );

?>

<form method="get" class="tst-opentable-form" action="//www.opentable.com/restaurant-search.aspx" target="_blank">
	<div class="row">
	  <div class="col-12<?php if ( ! $opentable_layout ) : ?> col-md-4<?php endif; ?>">
	    <select id="reservation_party" name="partySize">
			<option value="1">1 <?php echo esc_html__( 'Person', 'tastyc' ); ?></option>
			<option value="2" selected="selected">2 <?php echo esc_html__( 'People', 'tastyc' ); ?></option>
			<option value="3">3 <?php echo esc_html__( 'People', 'tastyc' ); ?></option>
			<option value="4">4 <?php echo esc_html__( 'People', 'tastyc' ); ?></option>
			<option value="5">5 <?php echo esc_html__( 'People', 'tastyc' ); ?></option>
			<option value="6">6 <?php echo esc_html__( 'People', 'tastyc' ); ?></option>
			<option value="7">7 <?php echo esc_html__( 'People', 'tastyc' ); ?></option>
			<option value="8">8 <?php echo esc_html__( 'People', 'tastyc' ); ?></option>
			<option value="9">9 <?php echo esc_html__( 'People', 'tastyc' ); ?></option>
			<option value="10">10 <?php echo esc_html__( 'People', 'tastyc' ); ?></option>
			<option value="11">11 <?php echo esc_html__( 'People', 'tastyc' ); ?></option>
			<option value="12">12 <?php echo esc_html__( 'People', 'tastyc' ); ?></option>
			<option value="13">13 <?php echo esc_html__( 'People', 'tastyc' ); ?></option>
			<option value="14">14 <?php echo esc_html__( 'People', 'tastyc' ); ?></option>
			<option value="15">15 <?php echo esc_html__( 'People', 'tastyc' ); ?></option>
			<option value="16">16 <?php echo esc_html__( 'People', 'tastyc' ); ?></option>
			<option value="17">17 <?php echo esc_html__( 'People', 'tastyc' ); ?></option>
			<option value="18">18 <?php echo esc_html__( 'People', 'tastyc' ); ?></option>
			<option value="19">19 <?php echo esc_html__( 'People', 'tastyc' ); ?></option>
			<option value="20">20 <?php echo esc_html__( 'People', 'tastyc' ); ?></option>
			<option value="21"><?php echo esc_html__( 'Larger party', 'tastyc' ); ?></option>
		</select>
	  </div>
	  <div class="col-12<?php if ( ! $opentable_layout ) : ?> col-md-4<?php endif; ?>">
	    <div class="datepicker__container">
	      <input id="reservation_date" name="startDate" class="datepicker-here" type="text" value="" placeholder="<?php echo esc_attr__( 'Date', 'tastyc' ); ?>" autocomplete="off" readonly="readonly">
	    </div>
	  </div>
	  <div class="col-12<?php if ( ! $opentable_layout ) : ?> col-md-4<?php endif; ?>">
	    <select id="reservation_time" name="ResTime">
			<?php
			//Time Loop
			$inc = 30 * 60;
			$start = ( strtotime( '8AM' ) ); // 6  AM
			$end = ( strtotime( '11:59PM' ) ); // 10 PM


			for ( $i = $start; $i <= $end; $i += $inc ) {
				// to the standart format
				$time      = date( 'g:i a', $i );
				$timeValue = date( 'g:ia', $i );
				$default   = "7:00pm";
				echo "<option value=\"$timeValue\" " . ( ( $timeValue == $default ) ? ' selected="selected" ' : "" ) . ">$time</option>" . PHP_EOL;
			}

			?>
		</select>
	  </div>
	</div>
	<button class="tst-btn" type="submit" name="button"><?php echo esc_html__( 'Reserve a table', 'tastyc' ); ?></button>
	<p class="tst-powered d-center tst-p-15-0"><?php echo wp_kses_post( '* Powered by <img src="' . home_url() . '/wp-content/themes/tastyc/assets/images/opentable.svg" alt="Powered by OpenTable" />', 'tastyc' ); ?></p>

	<input type="hidden" name="RestaurantID" class="RestaurantID" value="<?php echo esc_attr( $opentable_id ); ?>">
	<input type="hidden" name="rid" class="rid" value="<?php echo esc_attr( $opentable_id ); ?>">
	<input type="hidden" name="GeoID" class="GeoID" value="15">
	<input type="hidden" name="txtDateFormat" class="txtDateFormat" value="MM/dd/yyyy">
	<input type="hidden" name="RestaurantReferralID" class="RestaurantReferralID" value="<?php echo esc_attr( $opentable_id ); ?>">
	<input type="hidden" name="lang" class="lang" value="<?php echo esc_attr( $opentable_lang ); ?>">
</form>