<?php

/* Theme Info Class */
if ( ! function_exists( 'tastyc_theme_info' ) ) {
  function tastyc_theme_info() {
    $data = array();

    $theme = wp_get_theme();
    $theme_parent = $theme->parent();
    if ( !empty( $theme_parent ) ) {
      $theme = $theme_parent;
    }
    $data['slug'] = $theme->get_stylesheet();
    $data['name'] = $theme[ 'Name' ];
    $data['version'] = $theme[ 'Version' ];
    $data['author'] = $theme[ 'Author' ];
    $data['is_child'] = ! empty( $theme_parent );

    return $data;
  }
}
if ( ! class_exists( 'TastycThemeInfo' ) ) {
  class TastycThemeInfo {

    private static $_instance = null;

    public $slug;

    public $name;

    public $version;

    public $author;

    public $is_child;

    public static function instance() {
			if ( is_null( self::$_instance ) ) {
				self::$_instance = new self();
				self::$_instance->init();
			}
			return self::$_instance;
		}

    public function __construct() {

		}

    public function init() {
      $theme = wp_get_theme();
      $theme_parent = $theme->parent();
      if ( !empty( $theme_parent ) ) {
        $theme = $theme_parent;
      }

      $this->slug = $theme->get_stylesheet();
      $this->name = $theme[ 'Name' ];
      $this->version = $theme[ 'Version' ];
      $this->author = $theme[ 'Author' ];
      $this->is_child = ! empty( $theme_parent );
    }
  }
}

function tastyc_theme_info() {
  return TastycThemeInfo::instance();
}
add_action( 'plugins_loaded', 'tastyc_theme_info' );

/* Plugin Info Class */
if ( ! class_exists( 'TastycPluginInfo' ) ) {
  class TastycPluginInfo {

    private static $_instance = null;

    public $name;

    public $version;

    public $author;

    public $slug;

    public $capability;

    public $dashboard_uri;

    public static function instance() {
			if ( is_null( self::$_instance ) ) {
				self::$_instance = new self();
				self::$_instance->init();
			}
			return self::$_instance;
		}

    public function __construct() {

		}

    public function init() {
      $plugin = TastycPlugin::get_plugin_info();
      $status = get_option( 'Tastyc_lic_Status' );

      $this->name = $plugin['Name'];
      $this->version = $plugin['Version'];
      $this->author = $plugin[ 'Author' ];
      $this->slug = 'tastyc-plugin';
      $this->capability = ( $status == 'active' ) ? 'extended' : 'normal';
      $this->dashboard_uri = plugin_dir_url( __FILE__ );
    }
  }
}

function tastyc_plugin_info() {
  return TastycPluginInfo::instance();
}
add_action( 'plugins_loaded', 'tastyc_plugin_info' );

/*Activation Notice*/
if ( ! function_exists( 'tastyc_theme_activation_notice' ) ) {
	function tastyc_theme_activation_notice() {
	?>
		<div class="notice notice-warning">
			<p><?php echo wp_kses_post( 'Please activate Tastyc theme to unlock all features, premium plugins, demo content and receive theme updates automatically!', 'tastyc-plugin' ); ?></p>
			<p><?php echo sprintf( __( '<a href="%s" class="button button-primary">Activate Now</a>', 'tastyc-plugin' ), admin_url( 'admin.php?page=tastyc-theme-activation' ) ); ?></p>
		</div>
	<?php
	}
}

/* Activation Filter */
if ( ! function_exists( 'tastyc_is_theme_activated' ) ) {
	function tastyc_is_theme_activated() {
		return apply_filters( 'tastyc/is_theme_activated', false );
	}
}
