<?php
namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

/**
 * Tastyc About Us Widget.
 *
 * @since 1.0
 */
class Tastyc_About_Us_Widget extends Widget_Base {

	public function get_name() {
		return 'tastyc-about-us';
	}

	public function get_title() {
		return esc_html__( 'About Us', 'tastyc-plugin' );
	}

	public function get_icon() {
		return 'eicon-parallax';
	}

	public function get_categories() {
		return [ 'tastyc-category' ];
	}

	/**
	 * Register widget controls.
	 *
	 * @since 1.0
	 */
	protected function register_controls() {

		$this->start_controls_section(
			'content_tab',
			[
				'label' => esc_html__( 'Content', 'tastyc-plugin' ),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'subtitle',
			[
				'label'       => esc_html__( 'Subtitle', 'tastyc-plugin' ),
				'type'        => Controls_Manager::TEXTAREA,
				'placeholder' => esc_html__( 'Enter subtitle', 'tastyc-plugin' ),
				'default'     => esc_html__( 'Subtitle', 'tastyc-plugin' ),
			]
		);

		$this->add_control(
			'title',
			[
				'label'       => esc_html__( 'Title', 'tastyc-plugin' ),
				'type'        => Controls_Manager::TEXTAREA,
				'placeholder' => esc_html__( 'Enter title', 'tastyc-plugin' ),
				'default'     => esc_html__( 'Title', 'tastyc-plugin' ),
			]
		);

		$this->add_control(
			'title_tag',
			[
				'label'       => esc_html__( 'Title Tag', 'tastyc-plugin' ),
				'type'        => Controls_Manager::SELECT,
				'default' => 'h3',
				'options' => [
					'h1'  => __( 'H1', 'tastyc-plugin' ),
					'h2' => __( 'H2', 'tastyc-plugin' ),
					'h3' => __( 'H3', 'tastyc-plugin' ),
					'h4' => __( 'H4', 'tastyc-plugin' ),
					'div' => __( 'DIV', 'tastyc-plugin' ),
				],
			]
		);

		$this->add_control(
			'description',
			[
				'label'       => esc_html__( 'Description', 'tastyc-plugin' ),
				'type'        => Controls_Manager::WYSIWYG,
				'placeholder' => esc_html__( 'Enter your description', 'tastyc-plugin' ),
				'default'     => esc_html__( 'Type your description here', 'tastyc-plugin' ),
			]
		);

		$this->add_control(
			'button',
			[
				'label'       => esc_html__( 'Button (label)', 'tastyc-plugin' ),
				'label_block' => true,
				'type'        => Controls_Manager::TEXT,
				'placeholder' => esc_html__( 'Button', 'tastyc-plugin' ),
			]
		);

		$this->add_control(
			'link',
			[
				'label'       => esc_html__( 'Button (link)', 'tastyc-plugin' ),
				'type' => Controls_Manager::URL,
				'show_external' => true,
			]
		);

		$this->add_control(
			'social',
			[
				'label' => esc_html__( 'Social Links', 'tastyc-plugin' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => __( 'Yes', 'tastyc-plugin' ),
				'label_off' => __( 'No', 'tastyc-plugin' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);

		$this->add_control(
			'image',
			[
				'label' => esc_html__( 'Image', 'tastyc-plugin' ),
				'type' => Controls_Manager::MEDIA,
				'default' => [
					'url' => \Elementor\Utils::get_placeholder_image_src(),
				],
			]
		);

		$this->add_control(
			'video_id',
			[
				'label'       => esc_html__( 'Youtube Video (ID)', 'tastyc-plugin' ),
				'label_block' => true,
				'type'        => Controls_Manager::TEXT,
				'placeholder' => esc_html__( 'SXJqEnauNaY', 'tastyc-plugin' ),
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'content_styling',
			[
				'label'     => esc_html__( 'Content Styles', 'tastyc-plugin' ),
				'tab'       => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'subtitle_color',
			[
				'label'     => esc_html__( 'Subtitle Color', 'tastyc-plugin' ),
				'type'      => Controls_Manager::COLOR,
				'default'	=> '',
				'selectors' => [
					'{{WRAPPER}} .row .tst-suptitle' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'     => 'subtitle_typography',
				'label'     => esc_html__( 'Subtitle Typography', 'tastyc-plugin' ),
				'selector' => '{{WRAPPER}} .row .tst-suptitle',
			]
		);

		$this->add_control(
			'title_color',
			[
				'label'     => esc_html__( 'Title Color', 'tastyc-plugin' ),
				'type'      => Controls_Manager::COLOR,
				'default'	=> '',
				'selectors' => [
					'{{WRAPPER}} .row .tst-title--h' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'     => 'title_typography',
				'label'     => esc_html__( 'Title Typography', 'tastyc-plugin' ),
				'selector' => '{{WRAPPER}} .row .tst-title--h',
			]
		);

		$this->add_control(
			'description_color',
			[
				'label'     => esc_html__( 'Description Color', 'tastyc-plugin' ),
				'type'      => Controls_Manager::COLOR,
				'default'	=> '',
				'selectors' => [
					'{{WRAPPER}} .row .tst-text' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'label'     => esc_html__( 'Description Typography', 'tastyc-plugin' ),
				'name'     => 'description_typography',
				'selector' => '{{WRAPPER}} .row .tst-text',
			]
		);

		$this->add_control(
			'btn_color',
			[
				'label'     => esc_html__( 'Button Color', 'tastyc-plugin' ),
				'type'      => Controls_Manager::COLOR,
				'default'	=> '',
				'selectors' => [
					'{{WRAPPER}} .row .tst-btn' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'btn_bgcolor',
			[
				'label'     => esc_html__( 'Button BG Color', 'tastyc-plugin' ),
				'type'      => Controls_Manager::COLOR,
				'default'	=> '',
				'selectors' => [
					'{{WRAPPER}} .row .tst-btn' => 'background-color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'label'     => esc_html__( 'Button Typography', 'tastyc-plugin' ),
				'name'     => 'btn_typography',
				'selector' => '{{WRAPPER}} .row .tst-btn',
			]
		);

		$this->add_control(
			'play_btn_bg_color',
			[
				'label'     => esc_html__( 'Play Button BG Color', 'tastyc-plugin' ),
				'type'      => Controls_Manager::COLOR,
				'default'	=> '',
				'selectors' => [
					'{{WRAPPER}} .tst-about-cover .tst-play-button' => 'background-color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'play_btn_color',
			[
				'label'     => esc_html__( 'Play Button Color', 'tastyc-plugin' ),
				'type'      => Controls_Manager::COLOR,
				'default'	=> '',
				'selectors' => [
					'{{WRAPPER}} .tst-about-cover .tst-play-button' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'social_btn_color',
			[
				'label'     => esc_html__( 'Social Button Color', 'tastyc-plugin' ),
				'type'      => Controls_Manager::COLOR,
				'default'	=> '',
				'selectors' => [
					'{{WRAPPER}} .row .tst-icon-link' => 'color: {{VALUE}};',
				],
			]
		);

		$this->end_controls_section();
	}


	/**
	 * Render widget output on the frontend.
	 *
	 * @since 1.0
	 */
	protected function render() {
		$settings = $this->get_settings_for_display();

		$social_links = get_field( 'social_links', 'option' );

		$this->add_inline_editing_attributes( 'subtitle', 'basic' );
		$this->add_inline_editing_attributes( 'title', 'basic' );
		$this->add_inline_editing_attributes( 'button', 'none' );
		$this->add_inline_editing_attributes( 'description', 'advanced' );

		?>

		<!-- container -->
		<div class="container">

		<div class="row align-items-center flex-sm-row-reverse">

		<div class="col-lg-6">

		<!-- about text -->
		<div class="tst-mb-60">
		  <?php if ( $settings['subtitle'] ) : ?>
		  <div class="tst-suptitle tst-mb-15">
		  	<span <?php echo $this->get_render_attribute_string( 'subtitle' ); ?>>
				<?php echo wp_kses_post( $settings['subtitle'] ); ?>
			</span>
		  </div>
		  <?php endif; ?>
		  <?php if ( $settings['title'] ) : ?>
		  <<?php echo esc_attr( $settings['title_tag'] ); ?> class="tst-title--h tst-mb-30">
		  	<span <?php echo $this->get_render_attribute_string( 'title' ); ?>>
				<?php echo wp_kses_post( $settings['title'] ); ?>
			</span>
		  </<?php echo esc_attr( $settings['title_tag'] ); ?>>
		  <?php endif; ?>
		  <?php if ( $settings['description'] ) : ?>
		  <div class="tst-text tst-mb-30">
		  	<div <?php echo $this->get_render_attribute_string( 'description' ); ?>>
			  	<?php echo wp_kses_post( $settings['description'] ); ?>
			</div>
		  </div>
		  <?php endif; ?>
		  <?php if ( $settings['button'] ) : ?>
		  <a<?php if ( $settings['link'] ) : if ( $settings['link']['is_external'] ) : ?> target="_blank"<?php endif; ?><?php if ( $settings['link']['nofollow'] ) : ?> rel="nofollow"<?php endif; ?> href="<?php echo esc_url( $settings['link']['url'] ); ?>"<?php endif; ?> class="tst-btn tst-anima-link tst-mr-30">
		  	<span <?php echo $this->get_render_attribute_string( 'button' ); ?>>
					<?php echo wp_kses_post( $settings['button'] ); ?>
				</span>
				<span class="screen-reader-text"><?php echo esc_html( $settings['button'] ) . esc_html( $settings['title'] ); ?></span>
		  </a>
		  <?php endif; ?>
		  <?php if ( $settings['social'] == 'yes' ) : ?>
		  <?php foreach ( $social_links as $index => $item ) : ?>
			<a<?php if ( $item['url'] ) : ?> target="_blank" href="<?php echo esc_url( $item['url'] ); ?>"<?php endif; ?> class="tst-icon-link" title="<?php echo esc_attr( $item['title'] ); ?>">
			<?php echo wp_kses_post( $item['icon'] ); ?>
			</a>
		  <?php endforeach; ?>
		  <?php endif; ?>
		</div>
		<!-- about text end -->

		</div>

		<div class="col-lg-6">

		<!-- about video -->
		<div class="tst-about-cover tst-mb-60">
		  <?php if ( $settings['image'] ) : $image = wp_get_attachment_image_url( $settings['image']['id'], 'tastyc_950xAuto' ); ?>
		  <img src="<?php echo esc_url( $image ); ?>" alt="<?php echo esc_attr( $settings['subtitle'] ); ?>" class="tst-cover">
		  <?php endif; ?>
		  <div class="tst-overlay"></div>
		  <?php if ( $settings['video_id'] ) : ?>
		  <div class="tst-btn-animation"></div>
		  <a class="tst-play-button" data-magnific-video href="https://www.youtube.com/watch?v=<?php echo esc_attr( $settings['video_id'] ); ?>" data-width="10" data-height="600">
		    <i class="fas fa-play"></i>
		  </a>
		  <?php endif; ?>
		</div>
		<!-- about video end -->

		</div>

		</div>

		<div class="tst-spacer tst-spacer-only-bottom-space"></div>

		</div>
		<!-- container end -->

		<?php
	}

	/**
	 * Render widget output in the editor.
	 *
	 * Written as a Backbone JavaScript template and used to generate the live preview.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function content_template() {
		?>

		<#
		view.addInlineEditingAttributes( 'subtitle', 'basic' );
		view.addInlineEditingAttributes( 'title', 'basic' );
		view.addInlineEditingAttributes( 'button', 'none' );
		view.addInlineEditingAttributes( 'description', 'advanced' );
		#>

		<!-- container -->
		<div class="container">

		<div class="row align-items-center flex-sm-row-reverse">

		<div class="col-lg-6">

		<!-- about text -->
		<div class="tst-mb-60">
		  <# if ( settings.subtitle ) { #>
		  <div class="tst-suptitle tst-mb-15">
		  	<span {{{ view.getRenderAttributeString( 'subtitle' ) }}}>
	          	{{{ settings.subtitle }}}
	        </span>
		  </div>
		  <# } #>
		  <# if ( settings.title ) { #>
		  <{{{ settings.title_tag }}} class="tst-title--h tst-mb-30">
		  	<span {{{ view.getRenderAttributeString( 'title' ) }}}>
	          	{{{ settings.title }}}
	        </span>
		  </{{{ settings.title_tag }}}>
		  <# } #>
		  <# if ( settings.description ) { #>
		  <div class="tst-text tst-mb-30">
		  	<div {{{ view.getRenderAttributeString( 'description' ) }}}>
				{{{ settings.description }}}
			</div>
		  </div>
		  <# } #>
		  <# if ( settings.button ) { #>
		  <a<# if ( settings.link ) { if ( settings.link.is_external ) { #> target="_blank"<# } #><# if ( settings.link.nofollow ) { #> rel="nofollow"<# } #> href="{{{ settings.link.url }}}"<# } #> class="tst-btn tst-anima-link tst-mr-30">
		  	<span {{{ view.getRenderAttributeString( 'button' ) }}}>
				{{{ settings.button }}}
			</span>
		  </a>
		  <# } #>
		</div>
		<!-- about text end -->

		</div>

		<div class="col-lg-6">

		<!-- about video -->
		<div class="tst-about-cover tst-mb-60">
		  <# if ( settings.image ) { #>
		  <img src="{{{ settings.image.url }}}" alt="{{{ settings.subtitle }}}" class="tst-cover">
		  <# } #>
		  <div class="tst-overlay"></div>
		  <# if ( settings.video_id ) { #>
		  <div class="tst-btn-animation"></div>
		  <a class="tst-play-button" data-magnific-video href="https://www.youtube.com/watch?v={{{ settings.video_id }}}" data-width="10" data-height="600">
		    <i class="fas fa-play"></i>
		  </a>
		  <# } #>
		</div>
		<!-- about video end -->

		</div>

		</div>

		<div class="tst-spacer tst-spacer-only-bottom-space"></div>

		</div>
		<!-- container end -->

		<?php
	}
}

Plugin::instance()->widgets_manager->register( new Tastyc_About_Us_Widget() );
