<?php
namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

/**
 * Tastyc Call to Action Widget.
 *
 * @since 1.0
 */
class Tastyc_CTA_Widget extends Widget_Base {

	public function get_name() {
		return 'tastyc-cta';
	}

	public function get_title() {
		return esc_html__( 'Call to Action', 'tastyc-plugin' );
	}

	public function get_icon() {
		return 'eicon-parallax';
	}

	public function get_categories() {
		return [ 'tastyc-category' ];
	}

	/**
	 * Register widget controls.
	 *
	 * @since 1.0
	 */
	protected function register_controls() {

		$this->start_controls_section(
			'content_tab',
			[
				'label' => esc_html__( 'Content', 'tastyc-plugin' ),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'subtitle',
			[
				'label'       => esc_html__( 'Subtitle', 'tastyc-plugin' ),
				'type'        => Controls_Manager::TEXTAREA,
				'placeholder' => esc_html__( 'Enter subtitle', 'tastyc-plugin' ),
				'default'     => esc_html__( 'Subtitle', 'tastyc-plugin' ),
			]
		);

		$this->add_control(
			'title',
			[
				'label'       => esc_html__( 'Title', 'tastyc-plugin' ),
				'type'        => Controls_Manager::TEXTAREA,
				'placeholder' => esc_html__( 'Enter title', 'tastyc-plugin' ),
				'default'     => esc_html__( 'Title', 'tastyc-plugin' ),
			]
		);

		$this->add_control(
			'title_tag',
			[
				'label'       => esc_html__( 'Title Tag', 'tastyc-plugin' ),
				'type'        => Controls_Manager::SELECT,
				'default' => 'h2',
				'options' => [
					'h1'  => __( 'H1', 'tastyc-plugin' ),
					'h2' => __( 'H2', 'tastyc-plugin' ),
					'h3' => __( 'H3', 'tastyc-plugin' ),
					'h4' => __( 'H4', 'tastyc-plugin' ),
					'div' => __( 'DIV', 'tastyc-plugin' ),
				],
			]
		);

		$this->add_control(
			'description',
			[
				'label'       => esc_html__( 'Description', 'tastyc-plugin' ),
				'type'        => Controls_Manager::WYSIWYG,
				'placeholder' => esc_html__( 'Enter your description', 'tastyc-plugin' ),
				'default'     => esc_html__( 'Type your description here', 'tastyc-plugin' ),
			]
		);

		$this->add_control(
			'button1',
			[
				'label'       => esc_html__( 'Button 1 (label)', 'tastyc-plugin' ),
				'label_block' => true,
				'type'        => Controls_Manager::TEXT,
				'placeholder' => esc_html__( 'Button', 'tastyc-plugin' ),
			]
		);

		$this->add_control(
			'icon1',
			[
				'label'       => esc_html__( 'Button 1 (icon)', 'myour-plugin' ),
				'type'        => Controls_Manager::ICONS,
			]
		);

		$this->add_control(
			'link1',
			[
				'label'       => esc_html__( 'Button 1 (link)', 'tastyc-plugin' ),
				'type' => Controls_Manager::URL,
				'show_external' => true,
			]
		);

		$this->add_control(
			'button1_reservation',
			[
				'label'       => esc_html__( 'Button 1 (Reservation Popup)', 'tastyc-plugin' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => __( 'Yes', 'tastyc-plugin' ),
				'label_off' => __( 'No', 'tastyc-plugin' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);

		$this->add_control(
			'button2',
			[
				'label'       => esc_html__( 'Button 2 (label)', 'tastyc-plugin' ),
				'label_block' => true,
				'type'        => Controls_Manager::TEXT,
				'placeholder' => esc_html__( 'Button', 'tastyc-plugin' ),
			]
		);

		$this->add_control(
			'icon2',
			[
				'label'       => esc_html__( 'Button 2 (icon)', 'myour-plugin' ),
				'type'        => Controls_Manager::ICONS,
			]
		);

		$this->add_control(
			'link2',
			[
				'label'       => esc_html__( 'Button 2 (link)', 'tastyc-plugin' ),
				'type' => Controls_Manager::URL,
				'show_external' => true,
			]
		);

		$this->add_control(
			'button2_transparent',
			[
				'label'       => esc_html__( 'Button 2 (Transparent Style)', 'tastyc-plugin' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => __( 'Yes', 'tastyc-plugin' ),
				'label_off' => __( 'No', 'tastyc-plugin' ),
				'return_value' => 'yes',
				'default' => 'no',
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'image_tab',
			[
				'label' => esc_html__( 'Image', 'tastyc-plugin' ),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'image',
			[
				'label' => esc_html__( 'Image', 'tastyc-plugin' ),
				'type' => Controls_Manager::MEDIA,
				'default' => [
					'url' => \Elementor\Utils::get_placeholder_image_src(),
				],
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'content_styling',
			[
				'label'     => esc_html__( 'Content Styles', 'tastyc-plugin' ),
				'tab'       => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'subtitle_color',
			[
				'label'     => esc_html__( 'Subtitle Color', 'tastyc-plugin' ),
				'type'      => Controls_Manager::COLOR,
				'default'	=> '',
				'selectors' => [
					'{{WRAPPER}} .tst-call-to-action .tst-suptitle' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'     => 'subtitle_typography',
				'label'     => esc_html__( 'Subtitle Typography', 'tastyc-plugin' ),
				'selector' => '{{WRAPPER}} .tst-call-to-action .tst-suptitle',
			]
		);

		$this->add_control(
			'title_color',
			[
				'label'     => esc_html__( 'Title Color', 'tastyc-plugin' ),
				'type'      => Controls_Manager::COLOR,
				'default'	=> '',
				'selectors' => [
					'{{WRAPPER}} .tst-call-to-action .tst-title--h' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'     => 'title_typography',
				'label'     => esc_html__( 'Title Typography', 'tastyc-plugin' ),
				'selector' => '{{WRAPPER}} .tst-call-to-action .tst-title--h',
			]
		);

		$this->add_control(
			'description_color',
			[
				'label'     => esc_html__( 'Description Color', 'tastyc-plugin' ),
				'type'      => Controls_Manager::COLOR,
				'default'	=> '',
				'selectors' => [
					'{{WRAPPER}} .tst-call-to-action .tst-text' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'label'     => esc_html__( 'Description Typography', 'tastyc-plugin' ),
				'name'     => 'description_typography',
				'selector' => '{{WRAPPER}} .tst-call-to-action .tst-text',
			]
		);

		$this->add_control(
			'btn_color',
			[
				'label'     => esc_html__( 'Button Color', 'tastyc-plugin' ),
				'type'      => Controls_Manager::COLOR,
				'default'	=> '',
				'selectors' => [
					'{{WRAPPER}} .tst-call-to-action .tst-btn' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'btn_icon_color',
			[
				'label'     => esc_html__( 'Button Icon Color', 'tastyc-plugin' ),
				'type'      => Controls_Manager::COLOR,
				'default'	=> '',
				'selectors' => [
					'{{WRAPPER}} .tst-call-to-action .tst-btn i' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'label'     => esc_html__( 'Button Typography', 'tastyc-plugin' ),
				'name'     => 'btn_typography',
				'selector' => '{{WRAPPER}} .tst-call-to-action .tst-btn',
			]
		);

		$this->add_control(
			'btn_bgcolor',
			[
				'label'     => esc_html__( 'Button BG Color', 'tastyc-plugin' ),
				'type'      => Controls_Manager::COLOR,
				'default'	=> '',
				'selectors' => [
					'{{WRAPPER}} .tst-call-to-action .tst-btn' => 'background-color: {{VALUE}};',
				],
			]
		);

		$this->end_controls_section();
	}


	/**
	 * Render widget output on the frontend.
	 *
	 * @since 1.0
	 */
	protected function render() {
		$settings = $this->get_settings_for_display();

		$this->add_inline_editing_attributes( 'subtitle', 'basic' );
		$this->add_inline_editing_attributes( 'title', 'basic' );
		$this->add_inline_editing_attributes( 'button1', 'none' );
		$this->add_inline_editing_attributes( 'button2', 'none' );
		$this->add_inline_editing_attributes( 'description', 'advanced' );

		?>
		<div class="tst-content-frame--end tst-p-0-60"></div>

		<!-- call to action -->
	    <div class="tst-call-to-action">
	        <div class="container">

	          <div class="row align-items-center">
	            <div class="col-lg-6">
	              <!-- text -->
	              <div class="tst-cta-frame">
	                <div class="tst-cta">
	                  <?php if ( $settings['subtitle'] ) : ?>
	                  <div class="tst-suptitle tst-suptitle-mobile-md-center tst-text-shadow tst-white-2 tst-mb-15 tst-fade-up">
	                  	<span <?php echo $this->get_render_attribute_string( 'subtitle' ); ?>>
							<?php echo wp_kses_post( $settings['subtitle'] ); ?>
						</span>
	                  </div>
	                  <?php endif; ?>
	                  <?php if ( $settings['title'] ) : ?>
	                  <<?php echo esc_attr( $settings['title_tag'] ); ?> class="tst-title--h tst-white-2 tst-text-shadow tst-mb-30 tst-fade-up">
	                  	<span <?php echo $this->get_render_attribute_string( 'title' ); ?>>
							<?php echo wp_kses_post( $settings['title'] ); ?>
						</span>
	                  </<?php echo esc_attr( $settings['title_tag'] ); ?>>
	                  <?php endif; ?>
	                  <?php if ( $settings['description'] ) : ?>
	                  <div class="tst-fade-up">
	                    <div class="tst-text tst-text-lg tst-text-shadow tst-white-2">
	                    	<div <?php echo $this->get_render_attribute_string( 'description' ); ?>>
							  	<?php echo wp_kses_post( $settings['description'] ); ?>
							</div>
	                    </div>
	                  </div>
	                  <?php endif; ?>
	                  <?php if ( $settings['button1'] ) : ?>
	                  <a<?php if ( $settings['link1'] ) : if ( $settings['link1']['is_external'] ) : ?> target="_blank"<?php endif; ?><?php if ( $settings['link1']['nofollow'] ) : ?> rel="nofollow"<?php endif; ?> href="<?php echo esc_url( $settings['link1']['url'] ); ?>"<?php endif; ?> class="tst-btn tst-btn-lg tst-btn-shadow tst-mt-30 tst-fade-up<?php if ( $settings['button1_reservation'] == 'yes' ) : ?> tst-res-btn<?php endif; ?><?php if ( $settings['button2_transparent'] == 'yes' ) : ?> tst-mr-30<?php endif; ?>">
	                  	<?php \Elementor\Icons_Manager::render_icon( $settings['icon1'], [ 'aria-hidden' => 'true' ] ); ?>
	                  	<span <?php echo $this->get_render_attribute_string( 'button1' ); ?>>
							<?php echo wp_kses_post( $settings['button1'] ); ?>
						</span>
	                  </a>
	                  <?php endif; ?>
	                  <?php if ( $settings['button2'] ) : ?>
	                  <a<?php if ( $settings['link2'] ) : if ( $settings['link2']['is_external'] ) : ?> target="_blank"<?php endif; ?><?php if ( $settings['link2']['nofollow'] ) : ?> rel="nofollow"<?php endif; ?> href="<?php echo esc_url( $settings['link2']['url'] ); ?>"<?php endif; ?> class="<?php if ( $settings['button2_transparent'] == 'yes' ) : ?>tst-label tst-white-2 tst-fade-up<?php else : ?>tst-btn tst-btn-lg tst-btn-shadow tst-mt-30 tst-fade-up<?php endif; ?>">
	                  	<?php \Elementor\Icons_Manager::render_icon( $settings['icon2'], [ 'aria-hidden' => 'true' ] ); ?>
	                  	<span <?php echo $this->get_render_attribute_string( 'button2' ); ?>>
							<?php echo wp_kses_post( $settings['button2'] ); ?>
						</span>
	                  </a>
	                  <?php endif; ?>
	                </div>
	              </div>
	              <!-- text end -->

	            </div>
	            <div class="col-lg-6">
	              <?php if ( $settings['image'] ) : $image = wp_get_attachment_image_url( $settings['image']['id'], 'tastyc_950xAuto' ); ?>
	              <!-- image -->
	              <img src="<?php echo esc_url( $image ); ?>" alt="" class="tst-cta-image tst-fade-up">
	              <!-- image end -->
	              <?php endif; ?>
	            </div>
	          </div>
	        </div>
	    </div>
	    <!-- call to action end -->

	    <div class="tst-content-frame--start tst-p-60-0"></div>

		<?php
	}

	/**
	 * Render widget output in the editor.
	 *
	 * Written as a Backbone JavaScript template and used to generate the live preview.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function content_template() {
		?>

		<#
		view.addInlineEditingAttributes( 'subtitle', 'basic' );
		view.addInlineEditingAttributes( 'title', 'basic' );
		view.addInlineEditingAttributes( 'button1', 'none' );
		view.addInlineEditingAttributes( 'button2', 'none' );
		view.addInlineEditingAttributes( 'description', 'advanced' );

		var icon1_HTML = elementor.helpers.renderIcon( view, settings.icon1, { 'aria-hidden': true }, 'i' , 'object' );
		var icon2_HTML = elementor.helpers.renderIcon( view, settings.icon2, { 'aria-hidden': true }, 'i' , 'object' );
		#>

		<!-- call to action -->
	    <div class="tst-call-to-action">
	        <div class="container">

	          <div class="row align-items-center">
	            <div class="col-lg-6">
	              <!-- text -->
	              <div class="tst-cta-frame">
	                <div class="tst-cta">
	                  <# if ( settings.subtitle ) { #>
	                  <div class="tst-suptitle tst-suptitle-mobile-md-center tst-text-shadow tst-white-2 tst-mb-15 tst-fade-up">
	                  	<span {{{ view.getRenderAttributeString( 'subtitle' ) }}}>
				          	{{{ settings.subtitle }}}
				        </span>
	                  </div>
	                  <# } #>
	                  <# if ( settings.title ) { #>
	                  <{{{ settings.title_tag }}} class="tst-title--h tst-white-2 tst-text-shadow tst-mb-30 tst-fade-up">
	                  	<span {{{ view.getRenderAttributeString( 'title' ) }}}>
				          	{{{ settings.title }}}
				        </span>
	                  </{{{ settings.title_tag }}}>
	                  <# } #>
	                  <# if ( settings.description ) { #>
	                  <div class="tst-fade-up">
	                    <div class="tst-text tst-text-lg tst-text-shadow tst-white-2">
	                    	<div {{{ view.getRenderAttributeString( 'description' ) }}}>
								{{{ settings.description }}}
							</div>
	                    </div>
	                  </div>
	                  <# } #>
	                  <# if ( settings.button1 ) { #>
	                  <a<# if ( settings.link1 ) { if ( settings.link1.is_external ) { #> target="_blank"<# } #><# if ( settings.link1.nofollow ) { #> rel="nofollow"<# } #> href="{{{ settings.link1.url }}}"<# } #> class="tst-btn tst-btn-lg tst-btn-shadow tst-mt-30 tst-fade-up<# if ( settings.button1_reservation == 'yes' ) { #> tst-res-btn<# } #><# if ( settings.button2_transparent == 'yes' ) { #> tst-mr-30<# } #>">
	                  	{{{ icon1_HTML.value }}}
	                  	<span {{{ view.getRenderAttributeString( 'button1' ) }}}>
							{{{ settings.button1 }}}
						</span>
	                  </a>
	                  <# } #>
	                  <# if ( settings.button2 ) { #>
	                  <a<# if ( settings.link2 ) { if ( settings.link2.is_external ) { #> target="_blank"<# } #><# if ( settings.link2.nofollow ) { #> rel="nofollow"<# } #> href="{{{ settings.link2.url }}}"<# } #> class="<# if ( settings.button2_transparent == 'yes' ) { #>tst-label tst-white-2 tst-fade-up<# } else { #>tst-btn tst-btn-lg tst-btn-shadow tst-mt-30 tst-fade-up<# } #>">
	                  	{{{ icon2_HTML.value }}}
	                  	<span {{{ view.getRenderAttributeString( 'button2' ) }}}>
							{{{ settings.button2 }}}
						</span>
	                  </a>
	                  <# } #>
	                </div>
	              </div>
	              <!-- text end -->

	            </div>
	            <div class="col-lg-6">
	              <# if ( settings.image ) { #>
	              <!-- image -->
	              <img src="{{{ settings.image.url }}}" alt="" class="tst-cta-image tst-fade-up">
	              <!-- image end -->
	              <# } #>
	            </div>
	          </div>
	        </div>
	    </div>
	    <!-- call to action end -->

		<?php
	}
}

Plugin::instance()->widgets_manager->register( new Tastyc_CTA_Widget() );
