<?php
namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

/**
 * Tastyc Footer Back to Top Widget.
 *
 * @since 1.0
 */
class Tastyc_Footer_Backtotop_Widget extends Widget_Base {

	public function get_name() {
		return 'tastyc-footer-backtoptop';
	}

	public function get_title() {
		return esc_html__( 'Footer Back to Top', 'tastyc-plugin' );
	}

	public function get_icon() {
		return 'eicon-parallax';
	}

	public function get_categories() {
		return [ 'tastyc-category' ];
	}

	/**
	 * Register widget controls.
	 *
	 * @since 1.0
	 */
	protected function register_controls() {

		$this->start_controls_section(
			'content_tab',
			[
				'label' => esc_html__( 'Content', 'tastyc-plugin' ),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'button_text',
			[
				'label'       => esc_html__( 'Button (Text)', 'tastyc-plugin' ),
				'type'        => Controls_Manager::TEXT,
				'placeholder' => esc_html__( 'Enter text', 'tastyc-plugin' ),
				'default'     => esc_html__( 'Back to Top', 'tastyc-plugin' ),
			]
		);

		$this->add_responsive_control(
			'align',
			[
				'label' => __( 'Alignment', 'tastyc-plugin' ),
				'type' => Controls_Manager::CHOOSE,
				'options' => [
					'left' => [
						'title' => __( 'Left', 'tastyc-plugin' ),
						'icon' => 'eicon-text-align-left',
					],
					'center' => [
						'title' => __( 'Center', 'tastyc-plugin' ),
						'icon' => 'eicon-text-align-center',
					],
					'right' => [
						'title' => __( 'Right', 'tastyc-plugin' ),
						'icon' => 'eicon-text-align-right',
					],
				],
				'selectors' => [
					'{{WRAPPER}}' => 'text-align: {{VALUE}};',
				],
				'default'	=> 'left',
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'content_styling',
			[
				'label' => esc_html__( 'Content Styles', 'tastyc-plugin' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'link_color',
			[
				'label' => esc_html__( 'Link Color', 'tastyc-plugin' ),
				'type' => Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => [
					'{{WRAPPER}} .tst-label' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'link_typography',
				'label' => esc_html__( 'Link Typography:', 'tastyc-plugin' ),
				'selector' => '{{WRAPPER}} .tst-label',
			]
		);

		$this->end_controls_section();

	}


	/**
	 * Render widget output on the frontend.
	 *
	 * @since 1.0
	 */
	protected function render() {
		$settings = $this->get_settings_for_display();

		$this->add_inline_editing_attributes( 'button_text', 'none' );

		?>

		<?php if ( $settings['button_text'] ) : ?>
		<a href="#tst-app" class="tst-label tst-color tst-anchor-scroll">
			<span <?php echo $this->get_render_attribute_string( 'button_text' ); ?>>
				<?php echo wp_kses_post( $settings['button_text'] ); ?>
			</span>
		</a>
		<?php endif; ?>

		<?php
	}

	/**
	 * Render widget output in the editor.
	 *
	 * Written as a Backbone JavaScript template and used to generate the live preview.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function content_template() {
		?>
		<#
		view.addInlineEditingAttributes( 'button_text', 'none' );
		#>

		<# if ( settings.button_text ) { #>
		<a href="#tst-app" class="tst-label tst-color tst-anchor-scroll">
			<span {{{ view.getRenderAttributeString( 'button_text' ) }}}>
    			{{{ settings.button_text }}}
    		</span>
		</a>
		<# } #>

		<?php
	}
}

Plugin::instance()->widgets_manager->register( new Tastyc_Footer_Backtotop_Widget() );
