<?php
namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

/**
 * Tastyc Header Buttons Widget.
 *
 * @since 1.0
 */
class Tastyc_Header_Buttons_Widget extends Widget_Base {

	public function get_name() {
		return 'tastyc-header-buttons';
	}

	public function get_title() {
		return esc_html__( 'Header Buttons', 'tastyc-plugin' );
	}

	public function get_icon() {
		return 'eicon-parallax';
	}

	public function get_categories() {
		return [ 'tastyc-category' ];
	}

	/**
	 * Register widget controls.
	 *
	 * @since 1.0
	 */
	protected function register_controls() {

		$this->start_controls_section(
			'content_tab',
			[
				'label' => esc_html__( 'Content', 'tastyc-plugin' ),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'button_show',
			[
				'label' => esc_html__( 'Show Button', 'tastyc-plugin' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => __( 'Show', 'tastyc-plugin' ),
				'label_off' => __( 'Hide', 'tastyc-plugin' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);

		$this->add_control(
			'button',
			[
				'label'       => esc_html__( 'Button (label)', 'tastyc-plugin' ),
				'label_block' => true,
				'type'        => Controls_Manager::TEXT,
				'placeholder' => esc_html__( 'Button', 'tastyc-plugin' ),
				'default'	=> esc_html__( 'Button', 'tastyc-plugin' ),
				'condition' => [
		            'button_show' => 'yes'
		        ],
			]
		);

		$this->add_control(
			'link',
			[
				'label'       => esc_html__( 'Button (link)', 'tastyc-plugin' ),
				'type' => Controls_Manager::URL,
				'show_external' => true,
				'condition' => [
		            'button_show' => 'yes'
		        ],
			]
		);

		$this->add_control(
			'button_popup_show',
			[
				'label' => esc_html__( 'Enable Button Popup', 'tastyc-plugin' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => __( 'Yes', 'tastyc-plugin' ),
				'label_off' => __( 'No', 'tastyc-plugin' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);

		$this->add_control(
			'cart_show',
			[
				'label' => esc_html__( 'Show Shopping Cart', 'tastyc-plugin' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => __( 'Show', 'tastyc-plugin' ),
				'label_off' => __( 'Hide', 'tastyc-plugin' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);

		$this->add_responsive_control(
			'align',
			[
				'label' => __( 'Alignment', 'tastyc-plugin' ),
				'type' => Controls_Manager::CHOOSE,
				'options' => [
					'left' => [
						'title' => __( 'Left', 'tastyc-plugin' ),
						'icon' => 'eicon-text-align-left',
					],
					'center' => [
						'title' => __( 'Center', 'tastyc-plugin' ),
						'icon' => 'eicon-text-align-center',
					],
					'right' => [
						'title' => __( 'Right', 'tastyc-plugin' ),
						'icon' => 'eicon-text-align-right',
					],
				],
				'selectors' => [
					'{{WRAPPER}} .tst-menu-right' => 'justify-content: {{VALUE}};',
				],
				'default'	=> 'right',
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'content_styling',
			[
				'label' => esc_html__( 'Styles', 'tastyc-plugin' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'button_color',
			[
				'label' => esc_html__( 'Button Text Color', 'tastyc-plugin' ),
				'type' => Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => [
					'{{WRAPPER}} .tst-btn' => 'color: {{VALUE}};',
				],
			]
		);

    $this->add_control(
			'button_bg_color',
			[
				'label' => esc_html__( 'Button BG Color', 'tastyc-plugin' ),
				'type' => Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => [
					'{{WRAPPER}} .tst-btn' => 'background-color: {{VALUE}};',
				],
			]
		);

    $this->add_control(
			'button_border_color',
			[
				'label' => esc_html__( 'Button Border Color', 'tastyc-plugin' ),
				'type' => Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => [
					'{{WRAPPER}} .tst-btn' => 'border-color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'button_typography',
				'label' => esc_html__( 'Button Text Typography:', 'tastyc-plugin' ),
				'selector' => '{{WRAPPER}} .tst-btn',
			]
		);

		$this->end_controls_section();

	}


	/**
	 * Render widget output on the frontend.
	 *
	 * @since 1.0
	 */
	protected function render() {
		$settings = $this->get_settings_for_display();

		$this->add_inline_editing_attributes( 'button', 'none' );

		?>

		<div class="tst-menu-right">

			<?php if ( $settings['button_show'] == 'yes' ) : ?>
			<!-- reservation button -->
	        <a<?php if ( $settings['link'] ) : if ( $settings['link']['is_external'] ) : ?> target="_blank"<?php endif; ?><?php if ( $settings['link']['nofollow'] ) : ?> rel="nofollow"<?php endif; ?> href="<?php echo esc_url( $settings['link']['url'] ); ?>"<?php endif; ?> class="tst-btn <?php if ( $settings['button_popup_show'] == 'yes' ) : ?>tst-res-btn<?php endif; ?>" data-no-swup>
	        	<span <?php echo $this->get_render_attribute_string( 'button' ); ?>>
	          		<?php echo wp_kses_post( $settings['button'] ); ?>
	          	</span>
	        </a>
	        <?php endif; ?>

	        <?php if ( $settings['cart_show'] == 'yes' ) : ?>

	        <!-- Woocommerce cart -->
			<?php if ( class_exists( 'WooCommerce' ) ) : ?>
			<?php if ( true == get_theme_mod( 'cart_shop', true ) ) : $cart_total = 0; if ( is_object( WC()->cart ) ) : $cart_total = WC()->cart->get_cart_contents_count(); endif; ?>

	        <div class="tst-minicart">
	          <!-- minicart button -->
	          <div class="tst-cart">
	            <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 128 128">
	              <path
	                d="M87.7,33.1l-0.8-10.8C86,10.4,76,1,64,1s-22.1,9.4-22.9,21.3l-0.8,10.8H28.8c-4.7,0-8.6,3.7-9,8.4l-5.4,75.9c0,0,0,0,0,0 c-0.2,2.5,0.7,5,2.4,6.8s4.1,2.9,6.6,2.9h81.3c2.5,0,4.9-1,6.6-2.9c1.7-1.8,2.6-4.3,2.4-6.8l-5.4-75.2c-0.4-5.1-4.6-9-9.7-9H87.7z M47.1,22.7C47.7,13.9,55.1,7,64,7s16.3,6.9,16.9,15.7l0.7,10.4H46.3L47.1,22.7z M102.3,42.6l5.4,75.2c0.1,0.8-0.2,1.6-0.8,2.3 c-0.6,0.6-1.4,1-2.2,1H23.4c-0.8,0-1.6-0.3-2.2-1s-0.9-1.4-0.8-2.3h0l5.4-75.9c0.1-1.6,1.4-2.8,3-2.8h11.1l-0.6,8 c-0.1,1.7,1.1,3.1,2.8,3.2c0.1,0,0.1,0,0.2,0c1.6,0,2.9-1.2,3-2.8l0.6-8.4h36.2l0.6,8.4c0.1,1.7,1.5,2.9,3.2,2.8 c1.7-0.1,2.9-1.5,2.8-3.2l-0.6-8h10.5C100.5,39.1,102.1,40.6,102.3,42.6z" />
	            </svg>
	            <div class="tst-cart-number">
	            	<span class="cart-count"><?php echo sprintf (_n( '%d', '%d', $cart_total, 'tastyc' ), $cart_total ); ?></span>
	            </div>
	          </div>
	          <!-- minicart button end -->
	          <!-- minicart -->
	          <div class="tst-minicart-window">
	          	<div class="cart-widget">
							  <?php if ( is_object( WC()->cart ) ) : woocommerce_mini_cart(); endif; ?>
						  </div>
	          </div>
	        </div>
	        <!-- minicart end -->

	        <?php endif; ?>
			<?php endif; ?>

	        <?php endif; ?>

	        <!-- menu button -->
	        <div class="tst-menu-button-frame">
	          <div class="tst-menu-btn">
	            <div class="tst-burger">
	              <span></span>
	            </div>
	          </div>
	        </div>
	        <!-- menu button end -->
	    </div>

		<?php
	}

	/**
	 * Render widget output in the editor.
	 *
	 * Written as a Backbone JavaScript template and used to generate the live preview.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function content_template() {
		?>
		<#
		view.addInlineEditingAttributes( 'button', 'none' );
		#>

		<div class="tst-menu-right">
			<# if ( settings.button_show == 'yes' ) { #>
			<!-- reservation button -->
	        <a<# if ( settings.link ) { if ( settings.link.is_external ) { #> target="_blank"<# } #><# if ( settings.link.nofollow ) { #> rel="nofollow"<# } #> href="{{{ settings.link.url }}}"<# } #> class="tst-btn <# if ( settings.button_popup_show == 'yes' ) { #>tst-res-btn<# } #>" data-no-swup>
	        	<span {{{ view.getRenderAttributeString( 'button' ) }}}>
	          		{{{ settings.button }}}
	          	</span>
	        </a>
	        <# } #>

	        <# if ( settings.cart_show == 'yes' ) { #>
	        <div class="tst-minicart">
	          <!-- minicart button -->
	          <div class="tst-cart">
	            <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 128 128">
	              <path
	                d="M87.7,33.1l-0.8-10.8C86,10.4,76,1,64,1s-22.1,9.4-22.9,21.3l-0.8,10.8H28.8c-4.7,0-8.6,3.7-9,8.4l-5.4,75.9c0,0,0,0,0,0 c-0.2,2.5,0.7,5,2.4,6.8s4.1,2.9,6.6,2.9h81.3c2.5,0,4.9-1,6.6-2.9c1.7-1.8,2.6-4.3,2.4-6.8l-5.4-75.2c-0.4-5.1-4.6-9-9.7-9H87.7z M47.1,22.7C47.7,13.9,55.1,7,64,7s16.3,6.9,16.9,15.7l0.7,10.4H46.3L47.1,22.7z M102.3,42.6l5.4,75.2c0.1,0.8-0.2,1.6-0.8,2.3 c-0.6,0.6-1.4,1-2.2,1H23.4c-0.8,0-1.6-0.3-2.2-1s-0.9-1.4-0.8-2.3h0l5.4-75.9c0.1-1.6,1.4-2.8,3-2.8h11.1l-0.6,8 c-0.1,1.7,1.1,3.1,2.8,3.2c0.1,0,0.1,0,0.2,0c1.6,0,2.9-1.2,3-2.8l0.6-8.4h36.2l0.6,8.4c0.1,1.7,1.5,2.9,3.2,2.8 c1.7-0.1,2.9-1.5,2.8-3.2l-0.6-8h10.5C100.5,39.1,102.1,40.6,102.3,42.6z" />
	            </svg>
	            <div class="tst-cart-number">0</div>
	          </div>
	          <!-- minicart button end -->
	        </div>
	        <!-- minicart end -->
	        <# } #>

	        <!-- menu button -->
	        <div class="tst-menu-button-frame">
	          <div class="tst-menu-btn">
	            <div class="tst-burger">
	              <span></span>
	            </div>
	          </div>
	        </div>
	        <!-- menu button end -->
	    </div>

		<?php
	}
}

Plugin::instance()->widgets_manager->register( new Tastyc_Header_Buttons_Widget() );
