<?php
namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

/**
 * Tastyc Header Menu Widget.
 *
 * @since 1.0
 */

class Tastyc_Header_Menu_Widget extends Widget_Base {

	public function get_name() {
		return 'tastyc-header-menu';
	}

	public function get_title() {
		return esc_html__( 'Header Menu', 'tastyc-plugin' );
	}

	public function get_icon() {
		return 'eicon-parallax';
	}

	public function get_categories() {
		return [ 'tastyc-category' ];
	}

	/**
	 * Register widget controls.
	 *
	 * @since 1.0
	 */
	protected function register_controls() {

		$this->start_controls_section(
			'content_tab',
			[
				'label' => esc_html__( 'Content', 'tastyc-plugin' ),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'layout',
			[
				'label'       => esc_html__( 'Select Layout', 'tastyc-plugin' ),
				'type'        => Controls_Manager::SELECT,
				'default' => 2,
				'options' => [
					1  => __( 'Horizontal', 'tastyc-plugin' ),
				],
			]
		);

		$this->add_control(
			'menu',
			[
				'label' => esc_html__( 'Select Menu', 'tastyc-plugin' ),
				'type' => Controls_Manager::SELECT,
				'default' => '',
				'options' => $this->nav_menu_list(),
			]
		);

		$this->add_responsive_control(
			'align',
			[
				'label' => __( 'Alignment', 'tastyc-plugin' ),
				'type' => Controls_Manager::CHOOSE,
				'options' => [
					'left' => [
						'title' => __( 'Left', 'tastyc-plugin' ),
						'icon' => 'eicon-text-align-left',
					],
					'center' => [
						'title' => __( 'Center', 'tastyc-plugin' ),
						'icon' => 'eicon-text-align-center',
					],
					'right' => [
						'title' => __( 'Right', 'tastyc-plugin' ),
						'icon' => 'eicon-text-align-right',
					],
				],
				'selectors' => [
					'{{WRAPPER}}' => 'text-align: {{VALUE}};',
				],
				'default'	=> 'left',
			]
		);

		$this->end_controls_section();

    $this->start_controls_section(
			'content_styling',
			[
				'label' => esc_html__( 'Header Menu', 'tastyc-plugin' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'menu1_item_color',
			[
				'label' => esc_html__( 'Menu Item Color', 'tastyc-plugin' ),
				'type' => Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => [
					'{{WRAPPER}} .tst-menu-nav ul li a' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'menu1_item_hover_color',
			[
				'label' => esc_html__( 'Menu Item Hover Color', 'tastyc-plugin' ),
				'type' => Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => [
					'{{WRAPPER}} .tst-menu-nav ul li a:hover' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'menu1_item_typography',
				'label' => esc_html__( 'Menu Item Typography:', 'tastyc-plugin' ),
				'selector' => '{{WRAPPER}} .tst-menu-nav ul li a',
			]
		);

		$this->add_control(
			'menu1_sub_item_color',
			[
				'label' => esc_html__( 'Submenu Item Color', 'tastyc-plugin' ),
				'type' => Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => [
					'{{WRAPPER}} .tst-menu-nav ul li ul li a' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'menu1_sub_item_hover_color',
			[
				'label' => esc_html__( 'Submenu Item Hover Color', 'tastyc-plugin' ),
				'type' => Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => [
					'{{WRAPPER}} .tst-menu-nav ul li ul li a:hover' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'menu1_sub_item_typography',
				'label' => esc_html__( 'Submenu Item Typography:', 'tastyc-plugin' ),
				'selector' => '{{WRAPPER}} .tst-menu-nav ul li ul li a',
			]
		);

		$this->end_controls_section();
	}

	/**
	 * Render Contact Form List.
	 *
	 * @since 1.0
	 */
	protected function nav_menu_list() {
		$menus = wp_get_nav_menus();
		$items = array();
		$i = 0;

		foreach ( $menus as $menu ) {
			if ( $i == 0 ) {
				$default = $menu->slug;
				$i ++;
			}
			$items[ $menu->slug ] = $menu->name;
		}

		return $items;
	}

	/**
	 * Render widget output on the frontend.
	 *
	 * @since 1.0
	 */
	protected function render() {
		$settings = $this->get_settings_for_display();

		?>

		<div class="tst-menu-nav">
			<?php tastyc_get_topmenu( $settings['menu'] ); ?>
		</div>

		<?php
	}
}

Plugin::instance()->widgets_manager->register( new Tastyc_Header_Menu_Widget() );
