<?php
namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

/**
 * Tastyc Hero Banner Widget.
 *
 * @since 1.0
 */
class Tastyc_Hero_Banner_Widget extends Widget_Base {

	public function get_name() {
		return 'tastyc-hero-banner';
	}

	public function get_title() {
		return esc_html__( 'Hero Banner', 'tastyc-plugin' );
	}

	public function get_icon() {
		return 'eicon-parallax';
	}

	public function get_categories() {
		return [ 'tastyc-category' ];
	}

	/**
	 * Register widget controls.
	 *
	 * @since 1.0
	 */
	protected function register_controls() {

		$this->start_controls_section(
			'title_tab',
			[
				'label' => esc_html__( 'Title', 'tastyc-plugin' ),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'subtitle',
			[
				'label'       => esc_html__( 'Subtitle', 'tastyc-plugin' ),
				'type'        => Controls_Manager::TEXTAREA,
				'placeholder' => esc_html__( 'Enter subtitle', 'tastyc-plugin' ),
				'default'     => esc_html__( 'Subtitle', 'tastyc-plugin' ),
			]
		);

		$this->add_control(
			'title',
			[
				'label'       => esc_html__( 'Title', 'tastyc-plugin' ),
				'type'        => Controls_Manager::TEXTAREA,
				'placeholder' => esc_html__( 'Enter title', 'tastyc-plugin' ),
				'default'     => esc_html__( 'Title', 'tastyc-plugin' ),
			]
		);

		$this->add_control(
			'title_tag',
			[
				'label'       => esc_html__( 'Title Tag', 'tastyc-plugin' ),
				'type'        => Controls_Manager::SELECT,
				'default' => 'h1',
				'options' => [
					'h1'  => __( 'H1', 'tastyc-plugin' ),
					'h2' => __( 'H2', 'tastyc-plugin' ),
					'h3' => __( 'H3', 'tastyc-plugin' ),
					'div' => __( 'DIV', 'tastyc-plugin' ),
				],
			]
		);

    $this->add_control(
			'title_align', [
				'label'       => esc_html__( 'Layout', 'tastyc-plugin' ),
				'type'        => Controls_Manager::SELECT,
				'default' => 'left',
				'options' => [
					'left'  => __( 'Left', 'tastyc-plugin' ),
					'center' => __( 'Center', 'tastyc-plugin' ),
					'right' => __( 'Right', 'tastyc-plugin' ),
				],
			]
		);

		$this->add_control(
			'description',
			[
				'label'       => esc_html__( 'Description', 'tastyc-plugin' ),
				'type'        => Controls_Manager::TEXTAREA,
				'placeholder' => esc_html__( 'Enter description', 'tastyc-plugin' ),
				'default'     => esc_html__( 'Description', 'tastyc-plugin' ),
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'buttons_tab',
			[
				'label' => esc_html__( 'Buttons', 'tastyc-plugin' ),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'button1',
			[
				'label'       => esc_html__( 'Button 1 (label)', 'tastyc-plugin' ),
				'label_block' => true,
				'type'        => Controls_Manager::TEXT,
				'placeholder' => esc_html__( 'Button', 'tastyc-plugin' ),
				'default'	=> esc_html__( 'Button', 'tastyc-plugin' ),
			]
		);

		$this->add_control(
			'button1_reservation',
			[
				'label'       => esc_html__( 'Button 1 (Reservation Popup)', 'tastyc-plugin' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => __( 'Yes', 'tastyc-plugin' ),
				'label_off' => __( 'No', 'tastyc-plugin' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);

		$this->add_control(
			'button1_link',
			[
				'label'       => esc_html__( 'Button 1 (link)', 'tastyc-plugin' ),
				'type' => Controls_Manager::URL,
				'show_external' => true,
			]
		);

		$this->add_control(
			'button2',
			[
				'label'       => esc_html__( 'Button 2 (label)', 'tastyc-plugin' ),
				'label_block' => true,
				'type'        => Controls_Manager::TEXT,
				'placeholder' => esc_html__( 'Button', 'tastyc-plugin' ),
				'default'	=> esc_html__( 'Button', 'tastyc-plugin' ),
			]
		);

		$this->add_control(
			'button2_link',
			[
				'label'       => esc_html__( 'Button 2 (link)', 'tastyc-plugin' ),
				'type' => Controls_Manager::URL,
				'show_external' => true,
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'background_tab',
			[
				'label' => esc_html__( 'Background', 'tastyc-plugin' ),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'bg_type',
			[
				'label'       => esc_html__( 'Background Type', 'tastyc-plugin' ),
				'type'        => Controls_Manager::SELECT,
				'default' => 'image',
				'options' => [
					'image'  => __( 'Image', 'tastyc-plugin' ),
					'video' => __( 'Video', 'tastyc-plugin' ),
				],
			]
		);

		$this->add_control(
			'image',
			[
				'label'       => esc_html__( 'Background Image', 'tastyc-plugin' ),
				'type' => Controls_Manager::MEDIA,
				'default' => [
					'url' => \Elementor\Utils::get_placeholder_image_src(),
				],
				'condition' => [
					'bg_type' => 'image'
				]
			]
		);

		$this->add_control(
			'video',
			[
				'label'       => esc_html__( 'Video (link)', 'tastyc-plugin' ),
				'label_block' => true,
				'type'        => Controls_Manager::TEXT,
				'placeholder' => esc_html__( '/video.mp4', 'tastyc-plugin' ),
				'condition' => [
					'bg_type' => 'video'
				]
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'title_styling',
			[
				'label'     => esc_html__( 'Title', 'tastyc-plugin' ),
				'tab'       => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'subtitle_color',
			[
				'label'     => esc_html__( 'Subtitle Color', 'tastyc-plugin' ),
				'type'      => Controls_Manager::COLOR,
				'default'	=> '',
				'selectors' => [
					'{{WRAPPER}} .tst-banner .tst-suptitle' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'     => 'subtitle_typography',
				'label'     => esc_html__( 'Subtitle Typography', 'tastyc-plugin' ),
				'selector' => '{{WRAPPER}} .tst-banner .tst-suptitle',
			]
		);

		$this->add_control(
			'title_color',
			[
				'label'     => esc_html__( 'Title Color', 'tastyc-plugin' ),
				'type'      => Controls_Manager::COLOR,
				'default'	=> '',
				'selectors' => [
					'{{WRAPPER}} .tst-banner .tst-title--h' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'     => 'title_typography',
				'label'     => esc_html__( 'Title Typography', 'tastyc-plugin' ),
				'selector' => '{{WRAPPER}} .tst-banner .tst-title--h',
			]
		);

		$this->add_control(
			'desc_color',
			[
				'label'     => esc_html__( 'Description Color', 'tastyc-plugin' ),
				'type'      => Controls_Manager::COLOR,
				'default'	=> '',
				'selectors' => [
					'{{WRAPPER}} .tst-banner .tst-text' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'     => 'desc_typography',
				'label'     => esc_html__( 'Description Typography', 'tastyc-plugin' ),
				'selector' => '{{WRAPPER}} .tst-banner .tst-text',
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'button_styling',
			[
				'label'     => esc_html__( 'Button', 'tastyc-plugin' ),
				'tab'       => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'button1_color',
			[
				'label'     => esc_html__( 'Button 1 Color', 'tastyc-plugin' ),
				'type'      => Controls_Manager::COLOR,
				'default'	=> '',
				'selectors' => [
					'{{WRAPPER}} .tst-banner .tst-btn' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'button1_bgcolor',
			[
				'label'     => esc_html__( 'Button 1 BG Color', 'tastyc-plugin' ),
				'type'      => Controls_Manager::COLOR,
				'default'	=> '',
				'selectors' => [
					'{{WRAPPER}} .tst-banner .tst-btn' => 'background-color: {{VALUE}};',
				],
			]
		);

    $this->add_control(
			'button1_border_color',
			[
				'label' => esc_html__( 'Button 1 Border Color', 'tastyc-plugin' ),
				'type' => Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => [
					'{{WRAPPER}} .tst-banner .tst-btn.tst-btn-lg' => 'border-color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'     => 'button1_typography',
				'label'     => esc_html__( 'Button 1 Typography', 'tastyc-plugin' ),
				'selector' => '{{WRAPPER}} .tst-banner .tst-btn',
			]
		);

		$this->add_control(
			'button2_color',
			[
				'label'     => esc_html__( 'Button 2 Color', 'tastyc-plugin' ),
				'type'      => Controls_Manager::COLOR,
				'default'	=> '',
				'selectors' => [
					'{{WRAPPER}} .tst-banner .tst-label' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'     => 'button2_typography',
				'label'     => esc_html__( 'Button 2 Typography', 'tastyc-plugin' ),
				'selector' => '{{WRAPPER}} .tst-banner .tst-label',
			]
		);

		$this->end_controls_section();
	}


	/**
	 * Render widget output on the frontend.
	 *
	 * @since 1.0
	 */
	protected function render() {
		$settings = $this->get_settings_for_display();

		$this->add_inline_editing_attributes( 'subtitle', 'basic' );
		$this->add_inline_editing_attributes( 'title', 'basic' );
		$this->add_inline_editing_attributes( 'description', 'basic' );
		$this->add_inline_editing_attributes( 'button1', 'none' );
		$this->add_inline_editing_attributes( 'button2', 'none' );

		?>

		<!-- banner -->
	    <div class="tst-banner">
	        <div class="tst-cover-frame">
	          <?php if ( $settings['bg_type'] == 'image' ) : ?>
	          <?php if ( $settings['image'] ) : $image = wp_get_attachment_image_url( $settings['image']['id'], 'tastyc_1920xAuto' ); ?>
	          <img src="<?php echo esc_url( $image ); ?>" alt="" class="tst-cover tst-parallax">
	          <?php endif; ?>
	          <?php else : ?>
	          <video class="tst-cover tst-parallax" muted playsinline autoplay loop>
	            <source src="<?php echo esc_url( $settings['video'] ); ?>">
	          </video>
	      	  <?php endif; ?>
	          <div class="tst-overlay"></div>
	        </div>
	        <div class="tst-banner-content-frame<?php if ( $settings['title_align'] == 'center' ) : ?> tst-banner-layout-center<?php endif; ?>">
	          <div class="container">
	            <div class="tst-main-title-frame">
	              <div class="tst-main-title">
	                <?php if ( $settings['subtitle'] ) : ?>
	                <div class="tst-suptitle<?php if ( $settings['title_align'] == 'left' ) : ?> tst-suptitle-mobile-center<?php endif; ?><?php if ( $settings['title_align'] == 'center' ) : ?> tst-suptitle-center<?php endif; ?> tst-text-shadow tst-white-2 tst-mb-15">
	                	<span <?php echo $this->get_render_attribute_string( 'subtitle' ); ?>>
				          	<?php echo wp_kses_post( $settings['subtitle'] ); ?>
				            </span>
	                </div>
	                <?php endif; ?>
	                <?php if ( $settings['title'] ) : ?>
	                <<?php echo esc_attr( $settings['title_tag'] ); ?> class="tst-title--h tst-white-2 tst-text-shadow tst-mb-30">
	                	<span <?php echo $this->get_render_attribute_string( 'title' ); ?>>
				          	<?php echo wp_kses_post( $settings['title'] ); ?>
				        </span>
	                </<?php echo esc_attr( $settings['title_tag'] ); ?>>
	                <?php endif; ?>
	                <?php if ( $settings['description'] ) : ?>
	                <div class="tst-text tst-text-shadow tst-text-lg tst-white-2 tst-mb-30">
	                	<span <?php echo $this->get_render_attribute_string( 'description' ); ?>>
				          	<?php echo wp_kses_post( $settings['description'] ); ?>
				        </span>
	                </div>
	                <?php endif; ?>
	                <?php if ( $settings['button1'] ) : ?>
	                <a<?php if ( $settings['button1_link'] ) : ?><?php if ( $settings['button1_link']['is_external'] ) : ?> target="_blank"<?php endif; ?><?php if ( $settings['button1_link']['nofollow'] ) : ?> rel="nofollow"<?php endif; ?> href="<?php echo esc_url( $settings['button1_link']['url'] ); ?>"<?php endif; ?> class="tst-btn tst-btn-lg tst-btn-shadow<?php if ( $settings['button1_reservation'] == 'yes' ) : ?> tst-res-btn<?php endif; ?> tst-mr-30">
	                	<span <?php echo $this->get_render_attribute_string( 'button1' ); ?>>
				          	<?php echo wp_kses_post( $settings['button1'] ); ?>
				        </span>
	                </a>
	                <?php endif; ?>
	                <?php if ( $settings['button2'] ) : ?>
	                <a<?php if ( $settings['button2_link'] ) : ?><?php if ( $settings['button2_link']['is_external'] ) : ?> target="_blank"<?php endif; ?><?php if ( $settings['button2_link']['nofollow'] ) : ?> rel="nofollow"<?php endif; ?> href="<?php echo esc_url( $settings['button2_link']['url'] ); ?>"<?php endif; ?> class="tst-label tst-white-2">
	                	<span <?php echo $this->get_render_attribute_string( 'button2' ); ?>>
				          	<?php echo wp_kses_post( $settings['button2'] ); ?>
				        </span>
	                </a>
	                <?php endif; ?>
	              </div>
	            </div>
	          </div>
	        </div>
	    </div>
	    <!-- banner end -->

		<?php
	}

	/**
	 * Render widget output in the editor.
	 *
	 * Written as a Backbone JavaScript template and used to generate the live preview.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function content_template() {
		?>

		<#
		view.addInlineEditingAttributes( 'subtitle', 'basic' );
		view.addInlineEditingAttributes( 'title', 'basic' );
		view.addInlineEditingAttributes( 'description', 'basic' );
		view.addInlineEditingAttributes( 'button1', 'none' );
		view.addInlineEditingAttributes( 'button2', 'none' );
		#>

		<!-- banner -->
	    <div class="tst-banner">
	        <div class="tst-cover-frame">
	          <# if ( settings.bg_type == 'image' ) { #>
	          <# if ( settings.image ) { #>
	          <img src="{{{ settings.image.url }}}" alt="" class="tst-cover tst-parallax">
	          <# } #>
	          <# } else { #>
	          <video class="tst-cover tst-parallax" muted playsinline autoplay loop>
	            <source src="{{{ settings.video }}}">
	          </video>
	          <# } #>
	          <div class="tst-overlay"></div>
	        </div>
	        <div class="tst-banner-content-frame<# if ( settings.title_align == 'center' ) { #> tst-banner-layout-center<# } #>">
	          <div class="container">
	            <div class="tst-main-title-frame">
	              <div class="tst-main-title">
	                <# if ( settings.subtitle ) { #>
	                <div class="tst-suptitle<# if ( settings.title_align == 'left' ) { #> tst-suptitle-mobile-center<# } #><# if ( settings.title_align == 'center' ) { #> tst-suptitle-center<# } #> tst-text-shadow tst-white-2 tst-mb-15">
	                	<span {{{ view.getRenderAttributeString( 'subtitle' ) }}}>
				          	{{{ settings.subtitle }}}
				        </span>
	                </div>
	                <# } #>
	                <# if ( settings.title ) { #>
	                <{{{ settings.title_tag }}} class="tst-title--h tst-white-2 tst-text-shadow tst-mb-30">
	                	<span {{{ view.getRenderAttributeString( 'title' ) }}}>
				          	{{{ settings.title }}}
				        </span>
	                </{{{ settings.title_tag }}}>
	                <# } #>
	                <# if ( settings.description ) { #>
	                <div class="tst-text tst-text-shadow tst-text-lg tst-white-2 tst-mb-30">
	                	<span {{{ view.getRenderAttributeString( 'description' ) }}}>
				          	{{{ settings.description }}}
				        </span>
	                </div>
	                <# } #>
	                <# if ( settings.button1 ) { #>
	                <a<# if ( settings.button1_link ) { if ( settings.button1_link.is_external ) { #> target="_blank"<# } #><# if ( settings.button1_link.nofollow ) { #> rel="nofollow"<# } #> href="{{{ settings.button1_link.url }}}"<# } #> class="tst-btn tst-btn-lg tst-btn-shadow<# if ( settings.button1_reservation == 'yes' ) { #> tst-res-btn<# } #> tst-mr-30">
	                	<span {{{ view.getRenderAttributeString( 'button1' ) }}}>
				          	{{{ settings.button1 }}}
				        </span>
	                </a>
	                <# } #>
	                <# if ( settings.button2 ) { #>
	                <a<# if ( settings.button2_link ) { if ( settings.button2_link.is_external ) { #> target="_blank"<# } #><# if ( settings.button2_link.nofollow ) { #> rel="nofollow"<# } #> href="{{{ settings.button2_link.url }}}"<# } #> class="tst-label tst-white-2">
	                	<span {{{ view.getRenderAttributeString( 'button2' ) }}}>
				          	{{{ settings.button2 }}}
				        </span>
	                </a>
	                <# } #>
	              </div>
	            </div>
	          </div>
	        </div>
	    </div>
	    <!-- banner end -->

		<?php
	}
}

Plugin::instance()->widgets_manager->register( new Tastyc_Hero_Banner_Widget() );
