<?php
namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

/**
 * Tastyc Hero Slider Widget.
 *
 * @since 1.0
 */
class Tastyc_Hero_Slider_Widget extends Widget_Base {

	public function get_name() {
		return 'tastyc-hero-slider';
	}

	public function get_title() {
		return esc_html__( 'Hero Slider', 'tastyc-plugin' );
	}

	public function get_icon() {
		return 'eicon-parallax';
	}

	public function get_categories() {
		return [ 'tastyc-category' ];
	}

	/**
	 * Register widget controls.
	 *
	 * @since 1.0
	 */
	protected function register_controls() {

		$this->start_controls_section(
			'content_tab',
			[
				'label' => esc_html__( 'Content', 'tastyc-plugin' ),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
		);

		$repeater = new \Elementor\Repeater();

		$repeater->add_control(
			'image', [
				'label' => esc_html__( 'Image', 'tastyc-plugin' ),
				'type' => Controls_Manager::MEDIA,
				'default' => [
					'url' => \Elementor\Utils::get_placeholder_image_src(),
				],
			]
		);

		$repeater->add_control(
			'subtitle', [
				'label'       => esc_html__( 'Subtitle', 'tastyc-plugin' ),
				'type'        => Controls_Manager::TEXTAREA,
				'placeholder' => esc_html__( 'Enter subtitle', 'tastyc-plugin' ),
				'default' => esc_html__( 'Enter subtitle', 'tastyc-plugin' ),
			]
		);

		$repeater->add_control(
			'title_tag', [
				'label'       => esc_html__( 'Title Tag', 'tastyc-plugin' ),
				'type'        => Controls_Manager::SELECT,
				'default' => 'h1',
				'options' => [
					'h1'  => __( 'H1', 'tastyc-plugin' ),
					'h2' => __( 'H2', 'tastyc-plugin' ),
					'div' => __( 'DIV', 'tastyc-plugin' ),
				],
			]
		);

		$repeater->add_control(
			'title_align', [
				'label'       => esc_html__( 'Layout', 'tastyc-plugin' ),
				'type'        => Controls_Manager::SELECT,
				'default' => 'left',
				'options' => [
					'left'  => __( 'Left', 'tastyc-plugin' ),
					'center' => __( 'Center', 'tastyc-plugin' ),
					'right' => __( 'Right', 'tastyc-plugin' ),
				],
			]
		);

		$repeater->add_control(
			'title', [
				'label'       => esc_html__( 'Title', 'tastyc-plugin' ),
				'type'        => Controls_Manager::TEXTAREA,
				'placeholder' => esc_html__( 'Enter title', 'tastyc-plugin' ),
				'default' => esc_html__( 'Enter title', 'tastyc-plugin' ),
			]
		);

		$repeater->add_control(
			'description', [
				'label'       => esc_html__( 'Description', 'tastyc-plugin' ),
				'type'        => Controls_Manager::TEXTAREA,
				'placeholder' => esc_html__( 'Enter description', 'tastyc-plugin' ),
				'default' => esc_html__( 'Enter description', 'tastyc-plugin' ),
			]
		);

		$repeater->add_control(
			'button1_text', [
				'label' => esc_html__( 'Button 1 (Text)', 'tastyc-plugin' ),
				'label_block' => true,
				'type' => Controls_Manager::TEXT,
				'placeholder' => esc_html__( 'Button Text', 'tastyc-plugin' ),
				'default' => esc_html__( 'Button', 'tastyc-plugin' ),
			]
		);

		$repeater->add_control(
			'button1_link', [
				'label' => esc_html__( 'Button 1 (URL)', 'tastyc-plugin' ),
				'label_block' => true,
				'type' => Controls_Manager::URL,
				'show_external' => true,
			]
		);

		$repeater->add_control(
			'button1_reservation', [
				'label' => esc_html__( 'Button 1 (Reservation Popup)', 'tastyc-plugin' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => __( 'Yes', 'tastyc-plugin' ),
				'label_off' => __( 'No', 'tastyc-plugin' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);

		$repeater->add_control(
			'button2_text', [
				'label' => esc_html__( 'Button 2 (Text)', 'tastyc-plugin' ),
				'label_block' => true,
				'type' => Controls_Manager::TEXT,
				'placeholder' => esc_html__( 'Button Text', 'tastyc-plugin' ),
				'default' => esc_html__( 'Button', 'tastyc-plugin' ),
			]
		);

		$repeater->add_control(
			'button2_link', [
				'label' => esc_html__( 'Button 2 (URL)', 'tastyc-plugin' ),
				'label_block' => true,
				'type' => Controls_Manager::URL,
				'show_external' => true,
			]
		);

		$this->add_control(
			'items',
			[
				'label' => esc_html__( 'Items', 'tastyc-plugin' ),
				'type' => Controls_Manager::REPEATER,
				'prevent_empty' => false,
				'fields' => $repeater->get_controls(),
				'title_field' => '{{{ title }}}',
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'slider_settings_tab',
			[
				'label' => esc_html__( 'Slider Settings', 'tastyc-plugin' ),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'slider_autoplay',
			[
				'label' => __( 'Autoplay', 'tastyc-plugin' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => __( 'Yes', 'tastyc-plugin' ),
				'label_off' => __( 'No', 'tastyc-plugin' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);

		$this->add_control(
			'slider_delay',
			[
				'label' => esc_html__( 'Delay', 'tastyc-plugin' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'ms' ],
				'range' => [
					'ms' => [
						'min' => 1000,
						'max' => 100000,
						'step' => 10,
					],
				],
				'default' => [
					'unit' => 'ms',
					'size' => 2500,
				],
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'content_styling',
			[
				'label' => esc_html__( 'Content Styles', 'tastyc-plugin' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'subtitle_color',
			[
				'label' => esc_html__( 'Subtitle Color', 'tastyc-plugin' ),
				'type' => Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => [
					'{{WRAPPER}} .tst-main-slider .tst-suptitle' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'subtitle_link_color',
			[
				'label' => esc_html__( 'Subtitle Line Color', 'tastyc-plugin' ),
				'type' => Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => [
					'{{WRAPPER}} .tst-main-slider .tst-suptitle:before' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'subtitle_typography',
				'label' => esc_html__( 'Subtitle Typography:', 'tastyc-plugin' ),
				'selector' => '{{WRAPPER}} .tst-main-slider .tst-suptitle',
			]
		);

		$this->add_control(
			'title_color',
			[
				'label' => esc_html__( 'Title Color', 'tastyc-plugin' ),
				'type' => Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => [
					'{{WRAPPER}} .tst-main-slider .tst-title--h' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'title_typography',
				'label' => esc_html__( 'Title Typography:', 'tastyc-plugin' ),
				'selector' => '{{WRAPPER}} .tst-main-slider .tst-title--h',
			]
		);

		$this->add_control(
			'text_color',
			[
				'label' => esc_html__( 'Text Color', 'tastyc-plugin' ),
				'type' => Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => [
					'{{WRAPPER}} .tst-main-slider .tst-text' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'text_typography',
				'label' => esc_html__( 'Text Typography:', 'tastyc-plugin' ),
				'selector' => '{{WRAPPER}} .tst-main-slider .tst-text',
			]
		);

		$this->add_control(
			'button1_color',
			[
				'label' => esc_html__( 'Button 1 Color', 'tastyc-plugin' ),
				'type' => Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => [
					'{{WRAPPER}} .tst-main-slider .tst-btn' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'button1_bg_color',
			[
				'label' => esc_html__( 'Button 1 BG Color', 'tastyc-plugin' ),
				'type' => Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => [
					'{{WRAPPER}} .tst-main-slider .tst-btn.tst-btn-lg' => 'background-color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'button1_border_color',
			[
				'label' => esc_html__( 'Button 1 Border Color', 'tastyc-plugin' ),
				'type' => Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => [
					'{{WRAPPER}} .tst-main-slider .tst-btn.tst-btn-lg' => 'border-color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'button1_typography',
				'label' => esc_html__( 'Button 1 Typography:', 'tastyc-plugin' ),
				'selector' => '{{WRAPPER}} .tst-main-slider .tst-btn',
			]
		);

		$this->add_control(
			'button2_color',
			[
				'label' => esc_html__( 'Button 2 Color', 'tastyc-plugin' ),
				'type' => Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => [
					'{{WRAPPER}} .tst-main-slider .tst-label' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'button2_typography',
				'label' => esc_html__( 'Button 2 Typography:', 'tastyc-plugin' ),
				'selector' => '{{WRAPPER}} .tst-main-slider .tst-label',
			]
		);

		$this->add_control(
			'nav_color',
			[
				'label' => esc_html__( 'Navigation Arrows Color', 'tastyc-plugin' ),
				'type' => Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => [
					'{{WRAPPER}} .tst-main-slider-nav .tst-slider-btn' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'dots_color',
			[
				'label' => esc_html__( 'Navigation Dots Color', 'tastyc-plugin' ),
				'type' => Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => [
					'{{WRAPPER}} .tst-main-pagination .swiper-pagination-bullet' => 'border-color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'dots_active_color',
			[
				'label' => esc_html__( 'Navigation Dots Active Color', 'tastyc-plugin' ),
				'type' => Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => [
					'{{WRAPPER}} .tst-main-pagination .swiper-pagination-bullet.swiper-pagination-bullet-active' => 'border-color: {{VALUE}};',
				],
			]
		);

		$this->end_controls_section();
	}


	/**
	 * Render widget output on the frontend.
	 *
	 * @since 1.0
	 */
	protected function render() {
		$settings = $this->get_settings_for_display();

		?>

		<?php if ( $settings['items'] ) : ?>
		<div class="swiper-container tst-main-slider" style="overflow: visible"<?php if ( $settings['slider_delay'] ) : ?> data-swiper-delay="<?php echo esc_attr( $settings['slider_delay']['size'] ); ?>"<?php endif; ?> data-swiper-autoplay="<?php if ( $settings['slider_autoplay'] == 'yes' ) : echo 1; else : echo 0; endif; ?>">
			<div class="swiper-wrapper">
			  <?php
			    foreach ( $settings['items'] as $index => $item ) :
			    	$item_subtitle = $this->get_repeater_setting_key( 'subtitle', 'items', $index );
			    	$this->add_inline_editing_attributes( $item_subtitle, 'basic' );

			        $item_title = $this->get_repeater_setting_key( 'title', 'items', $index );
			    	$this->add_inline_editing_attributes( $item_title, 'basic' );

			    	$item_desc = $this->get_repeater_setting_key( 'description', 'items', $index );
			    	$this->add_inline_editing_attributes( $item_desc, 'basic' );

			    	$item_button1_text = $this->get_repeater_setting_key( 'button1_text', 'items', $index );
			    	$this->add_inline_editing_attributes( $item_button1_text, 'none' );

			    	$item_button2_text = $this->get_repeater_setting_key( 'button2_text', 'items', $index );
			    	$this->add_inline_editing_attributes( $item_button2_text, 'none' );
			  ?>
			  <div class="swiper-slide">

			    <!-- banner -->
			    <div class="tst-banner">
			      <div class="tst-cover-frame">
			      	<?php if ( $item['image'] ) : $image = wp_get_attachment_image_url( $item['image']['id'], 'tastyc_1920xAuto' ); ?>
			        <img src="<?php echo esc_url( $image ); ?>" alt="<?php echo esc_attr( $item['title'] ); ?>" class="tst-cover tst-parallax" data-swiper-parallax-y="120" data-swiper-parallax-scale="1.2"
			          data-swiper-parallax-duration="1000" />
			        <?php endif; ?>
			        <div class="tst-overlay"></div>
			      </div>
			      <div class="tst-banner-content-frame<?php if ( $item['title_align'] == 'center' ) : ?> tst-banner-layout-center<?php endif; ?>">
			        <div class="container">
			          <div class="tst-main-title-frame">
			            <div class="tst-main-title" data-swiper-parallax-y="200" data-swiper-parallax-scale=".8" data-swiper-parallax-duration="800">
			              <?php if ( $item['subtitle'] ) : ?>
			              <div class="tst-suptitle<?php if ( $item['title_align'] == 'left' ) : ?> tst-suptitle-mobile-center<?php endif; ?><?php if ( $item['title_align'] == 'center' ) : ?> tst-suptitle-center<?php endif; ?> tst-text-shadow tst-white-2 tst-mb-15">
			              	<span <?php echo $this->get_render_attribute_string( $item_subtitle ); ?>>
		    					<?php echo wp_kses_post( $item['subtitle'] ); ?>
		    				</span>
			              </div>
			              <?php endif; ?>
			              <?php if ( $item['title'] ) : ?>
			              <<?php echo esc_attr( $item['title_tag'] ); ?> class="tst-title--h tst-white-2 tst-text-shadow tst-mb-30">
			              	<span <?php echo $this->get_render_attribute_string( $item_title ); ?>>
	    						<?php echo wp_kses_post( $item['title'] ); ?>
	    					</span>
			              </<?php echo esc_attr( $item['title_tag'] ); ?>>
			              <?php endif; ?>
			              <?php if ( $item['description'] ) : ?>
			              <div class="tst-text tst-text-shadow tst-text-lg tst-white-2 tst-mb-30">
			              	<span <?php echo $this->get_render_attribute_string( $item_desc ); ?>>
	    						<?php echo wp_kses_post( $item['description'] ); ?>
	    					</span>
			              </div>
			              <?php endif; ?>
			              <?php if ( $item['button1_text'] ) : ?>
			              <a<?php if ( $item['button1_link'] ) : ?><?php if ( $item['button1_link']['is_external'] ) : ?> target="_blank"<?php endif; ?><?php if ( $item['button1_link']['nofollow'] ) : ?> rel="nofollow"<?php endif; ?> href="<?php echo esc_url( $item['button1_link']['url'] ); ?>"<?php endif; ?> class="tst-btn tst-btn-lg tst-btn-shadow<?php if ( $item['button1_reservation'] == 'yes' ) : ?> tst-res-btn<?php endif; ?> tst-mr-30">
			              	<span <?php echo $this->get_render_attribute_string( $item_button1_text ); ?>>
	    						<?php echo wp_kses_post( $item['button1_text'] ); ?>
	    					</span>
			              </a>
			              <?php endif; ?>
			              <?php if ( $item['button2_text'] ) : ?>
			              <a<?php if ( $item['button2_link'] ) : ?><?php if ( $item['button2_link']['is_external'] ) : ?> target="_blank"<?php endif; ?><?php if ( $item['button2_link']['nofollow'] ) : ?> rel="nofollow"<?php endif; ?> href="<?php echo esc_url( $item['button2_link']['url'] ); ?>"<?php endif; ?> class="tst-label tst-white-2">
			              	<span <?php echo $this->get_render_attribute_string( $item_button2_text ); ?>>
	    						<?php echo wp_kses_post( $item['button2_text'] ); ?>
	    					</span>
			              </a>
			              <?php endif; ?>
			            </div>
			          </div>
			        </div>
			      </div>
			    </div>
			    <!-- banner end -->

			  </div>
			  <?php endforeach; ?>

			  <div class="tst-main-slider-navigation">

			    <div class="tst-main-pagination"></div>

			    <div class="tst-main-slider-nav">
			      <div class="tst-slider-btn tst-main-prev"><i class="fas fa-arrow-left"></i></div>
			      <div class="tst-slider-btn tst-main-next"><i class="fas fa-arrow-right"></i></div>
			    </div>

			  </div>
			</div>
		</div>
		<?php endif; ?>

		<?php
	}

	/**
	 * Render widget output in the editor.
	 *
	 * Written as a Backbone JavaScript template and used to generate the live preview.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function content_template() { ?>

		<# if ( settings.items ) { #>
		<div class="swiper-container tst-main-slider" style="overflow: visible"<# if ( settings.slider_delay ) { #> data-swiper-delay="{{{ settings.slider_delay.size }}}"<# } #> data-swiper-autoplay="<# if ( settings.slider_autoplay == 'yes' ) { #>1<# } else { #>0<# } #>">
			<div class="swiper-wrapper">
			  <# _.each( settings.items, function( item, index ) {
		        var item_subtitle = view.getRepeaterSettingKey( 'subtitle', 'items', index );
		    	view.addInlineEditingAttributes( item_subtitle, 'basic' );

		    	var item_title = view.getRepeaterSettingKey( 'title', 'items', index );
		    	view.addInlineEditingAttributes( item_title, 'basic' );

		        var item_desc = view.getRepeaterSettingKey( 'description', 'items', index );
		    	view.addInlineEditingAttributes( item_desc, 'basic' );

		    	var item_button1_text = view.getRepeaterSettingKey( 'button1_text', 'items', index );
		    	view.addInlineEditingAttributes( item_button1_text, 'none' );

		    	var item_button2_text = view.getRepeaterSettingKey( 'button2_text', 'items', index );
		    	view.addInlineEditingAttributes( item_button2_text, 'none' );
			  #>
			  <div class="swiper-slide">

			    <!-- banner -->
			    <div class="tst-banner">
			      <div class="tst-cover-frame">
			      	<# if ( item.image ) { #>
			        <img src="{{{ item.image.url }}}" alt="{{{ item.title }}}" class="tst-cover tst-parallax" data-swiper-parallax-y="120" data-swiper-parallax-scale="1.2"
			          data-swiper-parallax-duration="1000" />
			        <# } #>
			        <div class="tst-overlay"></div>
			      </div>
			      <div class="tst-banner-content-frame<# if ( item.title_align == 'center' ) { #> tst-banner-layout-center<# } #>">
			        <div class="container">
			          <div class="tst-main-title-frame">
			            <div class="tst-main-title" data-swiper-parallax-y="200" data-swiper-parallax-scale=".8" data-swiper-parallax-duration="800">
			              <# if ( item.subtitle ) { #>
			              <div class="tst-suptitle<# if ( item.title_align == 'left' ) { #> tst-suptitle-mobile-center<# } #><# if ( item.title_align == 'center' ) { #> tst-suptitle-center<# } #> tst-text-shadow tst-white-2 tst-mb-15">
			              	<span {{{ view.getRenderAttributeString( item_subtitle ) }}}>{{{ item.subtitle }}}</span>
			              </div>
			              <# } #>
			              <# if ( item.title ) { #>
			              <{{{ item.title_tag }}} class="tst-title--h tst-white-2 tst-text-shadow tst-mb-30">
			              	<span {{{ view.getRenderAttributeString( item_title ) }}}>{{{ item.title }}}</span>
			              </{{{ item.title_tag }}}>
			              <# } #>
			              <# if ( item.description ) { #>
			              <div class="tst-text tst-text-shadow tst-text-lg tst-white-2 tst-mb-30">
			              	<span {{{ view.getRenderAttributeString( item_desc ) }}}>{{{ item.description }}}</span>
			              </div>
			              <# } #>
			              <# if ( item.button1_text ) { #>
			              <a<# if ( item.button1_link ) { #><# if ( item.button1_link.is_external ) { #> target="_blank"<# } #><# if ( item.button1_link.nofollow ) { #> rel="nofollow"<# } #> href="{{{ item.button1_link.url }}}"<# } #> class="tst-btn tst-btn-lg tst-btn-shadow<# if ( item.button1_reservation == 'yes' ) { #> tst-res-btn<# } #> tst-mr-30">
			              	<span {{{ view.getRenderAttributeString( item_button1_text ) }}}>{{{ item.button1_text }}}</span>
			              </a>
			              <# } #>
			              <# if ( item.button2_text ) { #>
			              <a<# if ( item.button2_link ) { #><# if ( item.button2_link.is_external ) { #> target="_blank"<# } #><# if ( item.button2_link.nofollow ) { #> rel="nofollow"<# } #> href="{{{ item.button2_link.url }}}"<# } #> class="tst-label tst-white-2">
			              	<span {{{ view.getRenderAttributeString( item_button2_text ) }}}>{{{ item.button2_text }}}</span>
			              </a>
			              <# } #>
			            </div>
			          </div>
			        </div>
			      </div>
			    </div>
			    <!-- banner end -->

			  </div>
			  <# }); #>

			  <div class="tst-main-slider-navigation">

			    <div class="tst-main-pagination"></div>

			    <div class="tst-main-slider-nav">
			      <div class="tst-slider-btn tst-main-prev"><i class="fas fa-arrow-left"></i></div>
			      <div class="tst-slider-btn tst-main-next"><i class="fas fa-arrow-right"></i></div>
			    </div>

			  </div>
			</div>
		</div>
		<# } #>

	<?php }
}

Plugin::instance()->widgets_manager->register( new Tastyc_Hero_Slider_Widget() );
