<?php
namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

/**
 * Tastyc Menu Simple Widget.
 *
 * @since 1.0
 */
class Tastyc_Menu_Simple_Widget extends Widget_Base {

	public function get_name() {
		return 'tastyc-menu-simple';
	}

	public function get_title() {
		return esc_html__( 'Menu', 'tastyc-plugin' );
	}

	public function get_icon() {
		return 'eicon-parallax';
	}

	public function get_categories() {
		return [ 'tastyc-category' ];
	}

	public function get_categories_settings() {
		$categories = [];
		$cats = [
			'all'  => 'All',
		];
		$array = (array) $this;

		$i = 0; foreach ($array as $key => $value) { $i++;
      $stackKey = (string) $key . '_str';
      $stackReplace = str_replace( 'Elementor\\Controls_Stack', '', $stackKey );

      if ( stripos( $stackReplace, 'data_str' ) !== false ) {
				$categories = $value['settings']['categories'];
			}
		}

		if ( $categories ) {
			foreach ($categories as $value) {
				$ind = (string)$value['id'];
				$val = (string)$value['title'];
				$cats[$ind] = $val;
			}
		}

		return $cats;
	}

	/**
	 * Register widget controls.
	 *
	 * @since 1.0
	 */
	protected function register_controls() {

		$this->start_controls_section(
			'categories_tab',
			[
				'label' => esc_html__( 'Menu Categories', 'tastyc-plugin' ),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
		);

		$repeater = new \Elementor\Repeater();

		$repeater->add_control(
			'title', [
				'label'       => esc_html__( 'Title', 'tastyc-plugin' ),
				'type'        => Controls_Manager::TEXTAREA,
				'placeholder' => esc_html__( 'Enter title', 'tastyc-plugin' ),
				'default'     => esc_html__( 'Title', 'tastyc-plugin' ),
			]
		);

		$repeater->add_control(
			'id', [
				'label'       => esc_html__( 'Slug *', 'tastyc-plugin' ),
				'type'        => Controls_Manager::TEXT,
				'label_block' => true,
				'placeholder' => esc_html__( 'Enter unique Slug', 'tastyc-plugin' ),
				'default'     => esc_html__( 'unique-category-slug', 'tastyc-plugin' ),
			]
		);

		$repeater->add_control(
			'note',
			[
				'type' => Controls_Manager::RAW_HTML,
				'raw' => esc_html__( 'IMPORTANT! Enter unique category name slug', 'tastyc-plugin' ),
				'content_classes' => 'elementor-descriptor',
			]
		);

		$repeater->add_control(
			'subtitle', [
				'label'       => esc_html__( 'Subtitle', 'tastyc-plugin' ),
				'type'        => Controls_Manager::TEXTAREA,
				'placeholder' => esc_html__( 'Enter subtitle', 'tastyc-plugin' ),
				'default'     => esc_html__( 'Subtitle', 'tastyc-plugin' ),
			]
		);

		$repeater->add_control(
			'description', [
				'label'       => esc_html__( 'Description', 'tastyc-plugin' ),
				'type'        => Controls_Manager::TEXTAREA,
				'placeholder' => esc_html__( 'Enter description', 'tastyc-plugin' ),
				'default'     => esc_html__( 'Description', 'tastyc-plugin' ),
			]
		);

		$this->add_control(
			'categories',
			[
				'label' => esc_html__( 'Categories', 'tastyc-plugin' ),
				'type' => Controls_Manager::REPEATER,
				'prevent_empty' => false,
				'fields' => $repeater->get_controls(),
				'title_field' => '{{{ title }}}',
			]
		);

		$this->add_control(
			'categories_note',
			[
				'type' => Controls_Manager::RAW_HTML,
				'raw' => esc_html__( 'IMPORTANT! After change this field click "update" button and refresh the browser page.', 'tastyc-plugin' ),
				'content_classes' => 'elementor-descriptor',
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'items_tab',
			[
				'label' => esc_html__( 'Menu Items', 'tastyc-plugin' ),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
		);

		$repeater = new \Elementor\Repeater();

		$repeater->add_control(
			'category', [
				'label'       => esc_html__( 'Category', 'tastyc-plugin' ),
				'type'        => Controls_Manager::SELECT,
				'default'     => 'all',
				'options' => $this->get_categories_settings(),
			]
		);

		$repeater->add_control(
			'categories_note',
			[
				'type' => Controls_Manager::RAW_HTML,
				'raw' => esc_html__( 'IMPORTANT! After you added/edit new category need to click "update" button and refresh the browser page.', 'tastyc-plugin' ),
				'content_classes' => 'elementor-descriptor',
			]
		);

		$repeater->add_control(
			'image', [
				'label' => esc_html__( 'Image', 'tastyc-plugin' ),
				'type' => Controls_Manager::MEDIA,
				'default' => [
					'url' => \Elementor\Utils::get_placeholder_image_src(),
				],
			]
		);

		$repeater->add_control(
			'title', [
				'label'       => esc_html__( 'Title', 'tastyc-plugin' ),
				'type'        => Controls_Manager::TEXTAREA,
				'placeholder' => esc_html__( 'Enter title', 'tastyc-plugin' ),
				'default'     => esc_html__( 'Title', 'tastyc-plugin' ),
			]
		);

		$repeater->add_control(
			'description', [
				'label'       => esc_html__( 'Description', 'tastyc-plugin' ),
				'type'        => Controls_Manager::TEXTAREA,
				'placeholder' => esc_html__( 'Enter description', 'tastyc-plugin' ),
				'default'     => esc_html__( 'Description', 'tastyc-plugin' ),
			]
		);

		$repeater->add_control(
			'price', [
				'label'       => esc_html__( 'Price', 'tastyc-plugin' ),
				'type'        => Controls_Manager::TEXT,
				'label_block' => true,
				'placeholder' => esc_html__( 'Enter price', 'tastyc-plugin' ),
				'default'     => esc_html__( '$9.99', 'tastyc-plugin' ),
			]
		);

		$this->add_control(
			'items',
			[
				'label' => esc_html__( 'Items', 'tastyc-plugin' ),
				'type' => Controls_Manager::REPEATER,
				'prevent_empty' => false,
				'fields' => $repeater->get_controls(),
				'title_field' => '{{{ title }}}',
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'list_settings_tab',
			[
				'label' => esc_html__( 'List Settings', 'tastyc-plugin' ),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'layout',
			[
				'label'       => esc_html__( 'Layout', 'tastyc-plugin' ),
				'type'        => Controls_Manager::SELECT,
				'default' => 'list',
				'options' => [
					'list'  => __( 'List', 'tastyc-plugin' ),
					'tabs' => __( 'Tabs', 'tastyc-plugin' ),
				],
			]
		);

		$this->add_control(
			'show_cat_desc',
			[
				'label' => esc_html__( 'Show Description in Tabs layout?', 'tastyc-plugin' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => __( 'Show', 'tastyc-plugin' ),
				'label_off' => __( 'Hide', 'tastyc-plugin' ),
				'return_value' => 'yes',
				'default' => 'no',
				'condition' => [
		            'layout' => 'tabs'
		        ],
			]
		);

		$this->end_controls_section();


		$this->start_controls_section(
			'item_settings_tab',
			[
				'label' => esc_html__( 'Item Settings', 'tastyc-plugin' ),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'show_item_image',
			[
				'label' => esc_html__( 'Show Item Image?', 'tastyc-plugin' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => __( 'Show', 'tastyc-plugin' ),
				'label_off' => __( 'Hide', 'tastyc-plugin' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);

		$this->add_control(
			'show_item_desc',
			[
				'label' => esc_html__( 'Show Item Description?', 'tastyc-plugin' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => __( 'Show', 'tastyc-plugin' ),
				'label_off' => __( 'Hide', 'tastyc-plugin' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);

		$this->add_control(
			'show_item_price',
			[
				'label' => esc_html__( 'Show Item Price?', 'tastyc-plugin' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => __( 'Show', 'tastyc-plugin' ),
				'label_off' => __( 'Hide', 'tastyc-plugin' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'heading_styling',
			[
				'label'     => esc_html__( 'Heading', 'tastyc-plugin' ),
				'tab'       => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'subtitle_color',
			[
				'label'     => esc_html__( 'Subtitle Color', 'tastyc-plugin' ),
				'type'      => Controls_Manager::COLOR,
				'default'	=> '',
				'selectors' => [
					'{{WRAPPER}} .row .tst-suptitle' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'     => 'subtitle_typography',
				'label'     => esc_html__( 'Subtitle Typography', 'tastyc-plugin' ),
				'selector' => '{{WRAPPER}} .row .tst-suptitle',
			]
		);

		$this->add_control(
			'title_color',
			[
				'label'     => esc_html__( 'Title Color', 'tastyc-plugin' ),
				'type'      => Controls_Manager::COLOR,
				'default'	=> '',
				'selectors' => [
					'{{WRAPPER}} .row .tst-title--h' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'     => 'title_typography',
				'label'     => esc_html__( 'Title Typography', 'tastyc-plugin' ),
				'selector' => '{{WRAPPER}} .row .tst-title--h',
			]
		);

		$this->add_control(
			'desc_color',
			[
				'label'     => esc_html__( 'Description Color', 'tastyc-plugin' ),
				'type'      => Controls_Manager::COLOR,
				'default'	=> '',
				'selectors' => [
					'{{WRAPPER}} .row .tst-text--description' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'     => 'desc_typography',
				'label'     => esc_html__( 'Description Typography', 'tastyc-plugin' ),
				'selector' => '{{WRAPPER}} .row .tst-text--description',
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'tabs_styling',
			[
				'label'     => esc_html__( 'Tabs Link', 'tastyc-plugin' ),
				'tab'       => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'tabs_color',
			[
				'label'     => esc_html__( 'Link Color', 'tastyc-plugin' ),
				'type'      => Controls_Manager::COLOR,
				'default'	=> '',
				'selectors' => [
					'{{WRAPPER}} .swiper-menu-nav .swiper-pagination-bullet' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'tabs_active_color',
			[
				'label'     => esc_html__( 'Active Link Color', 'tastyc-plugin' ),
				'type'      => Controls_Manager::COLOR,
				'default'	=> '',
				'selectors' => [
					'{{WRAPPER}} .swiper-menu-nav .swiper-pagination-bullet-active' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'tabs_active_bgcolor',
			[
				'label'     => esc_html__( 'Active Link BG Color', 'tastyc-plugin' ),
				'type'      => Controls_Manager::COLOR,
				'default'	=> '',
				'selectors' => [
					'{{WRAPPER}} .swiper-menu-nav .swiper-pagination-bullet-active' => 'background-color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'     => 'filters_typography',
				'label'     => esc_html__( 'Tabs Typography', 'tastyc-plugin' ),
				'selector' => '{{WRAPPER}} .swiper-menu-nav .swiper-pagination-bullet',
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'items_styling',
			[
				'label'     => esc_html__( 'Items', 'tastyc-plugin' ),
				'tab'       => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'item_bg_color',
			[
				'label'     => esc_html__( 'Item BG Color', 'tastyc-plugin' ),
				'type'      => Controls_Manager::COLOR,
				'default'	=> '',
				'selectors' => [
					'{{WRAPPER}} .tst-menu-book-item' => 'background-color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'item_title_color',
			[
				'label'     => esc_html__( 'Title Color', 'tastyc-plugin' ),
				'type'      => Controls_Manager::COLOR,
				'default'	=> '',
				'selectors' => [
					'{{WRAPPER}} .tst-menu-book-name h5' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'     => 'item_title_typography',
				'label'     => esc_html__( 'Title Typography', 'tastyc-plugin' ),
				'selector' => '{{WRAPPER}} .tst-menu-book-name h5',
			]
		);

		$this->add_control(
			'item_text_color',
			[
				'label'     => esc_html__( 'Text Color', 'tastyc-plugin' ),
				'type'      => Controls_Manager::COLOR,
				'default'	=> '',
				'selectors' => [
					'{{WRAPPER}} .tst-menu-book-name .tst-text' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'     => 'item_text_typography',
				'label'     => esc_html__( 'Text Typography', 'tastyc-plugin' ),
				'selector' => '{{WRAPPER}} .tst-menu-book-name .tst-text',
			]
		);

		$this->add_control(
			'item_price_color',
			[
				'label'     => esc_html__( 'Price Color', 'tastyc-plugin' ),
				'type'      => Controls_Manager::COLOR,
				'default'	=> '',
				'selectors' => [
					'{{WRAPPER}} .tst-menu-book-price .tst-price' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'     => 'item_price_typography',
				'label'     => esc_html__( 'Price Typography', 'tastyc-plugin' ),
				'selector' => '{{WRAPPER}} .tst-menu-book-price .tst-price',
			]
		);

		$this->end_controls_section();
	}

	/**
	 * Render widget output on the frontend.
	 *
	 * @since 1.0
	 */
	protected function render() {
		$settings = $this->get_settings_for_display();

		$theme_lightbox = get_field( 'portfolio_lightbox_disable', 'option' );

		?>

		<!-- container -->
		<div class="container swiper-menu-container">

			<?php if ( $settings['layout'] == 'tabs' ) : ?>

			<div class="row">


			  <?php if ( $settings['categories'] ) : ?>
              <div class="col-lg-12">
                <div class="swiper-menu-nav">
                	<?php foreach ( $settings['categories'] as $index => $category ) :
					  $category_title = $this->get_repeater_setting_key( 'title', 'categories', $index );
					  $this->add_inline_editing_attributes( $category_title, 'basic' );
					?>
                	<span class="span-category">
                		<span <?php echo $this->get_render_attribute_string( $category_title ); ?>>
				          	<?php echo wp_kses_post( $category['title'] ); ?>
				         </span>
                	</span>
                	<?php endforeach; ?>
                </div>

                <div class="tst-spacer tst-spacer-only-bottom-space"></div>

              </div>
              <?php endif; ?>

              <?php if ( $settings['categories'] ) : ?>
              <div class="col-lg-12">
                <!-- Slider main container -->
                <div class="swiper-container swiper-menu">
                  <!-- Additional required wrapper -->
                  <div class="swiper-wrapper">
                    <!-- Slides -->
										<?php foreach ( $settings['categories'] as $index => $category ) :
											$category_title = $this->get_repeater_setting_key( 'title', 'categories', $index );
											$this->add_inline_editing_attributes( $category_title, 'basic' );

											$category_subtitle = $this->get_repeater_setting_key( 'subtitle', 'categories', $index );
											$this->add_inline_editing_attributes( $category_subtitle, 'basic' );

											$category_desc = $this->get_repeater_setting_key( 'description', 'categories', $index );
											$this->add_inline_editing_attributes( $category_desc, 'basic' );
										?>
                    <div class="swiper-slide">
											<?php if ( $settings['show_cat_desc'] == 'yes' ) : ?>
											<div class="col-lg-12">

				                <!-- title -->
				                <div class="text-center">
				                  <?php if ( $category['subtitle'] ) : ?>
				                  <div class="tst-suptitle tst-suptitle-center tst-mb-15">
				                  	<span <?php echo $this->get_render_attribute_string( $category_subtitle ); ?>>
							          	<?php echo wp_kses_post( $category['subtitle'] ); ?>
							        </span>
				                  </div>
				                  <?php endif; ?>
				                  <?php if ( $category['title'] ) : ?>
				                  <h3 class="tst-title--h tst-mb-30">
				                  	<span <?php echo $this->get_render_attribute_string( $category_title ); ?>>
							          	<?php echo wp_kses_post( $category['title'] ); ?>
							        </span>
				                  </h3>
				                  <?php endif; ?>
				                  <?php if ( $category['description'] ) : ?>
				                  <p class="tst-text tst-text--description tst-mb-60">
				                  	<span <?php echo $this->get_render_attribute_string( $category_desc ); ?>>
							          	<?php echo wp_kses_post( $category['description'] ); ?>
							        </span>
				                  </p>
				                  <?php endif; ?>
				                </div>
				                <!-- title end -->

				              </div>
											<?php endif; ?>
                      <?php if ( $settings['items'] ) : ?>
                      <div class="row">
                      	<?php foreach ( $settings['items'] as $index => $item ) :
                      	  $item_title = $this->get_repeater_setting_key( 'title', 'items', $index );
					  	  $this->add_inline_editing_attributes( $item_title, 'basic' );

					  	  $item_description = $this->get_repeater_setting_key( 'description', 'items', $index );
					  	  $this->add_inline_editing_attributes( $item_description, 'basic' );

					  	  $item_price = $this->get_repeater_setting_key( 'price', 'items', $index );
					  	  $this->add_inline_editing_attributes( $item_price, 'basic' );
                      	?>
                      	<?php if ( $category['id'] == $item['category'] || $item['category'] == 'all' ) : ?>
                        <div class="col-lg-6">

                          <div class="tst-menu-book-item tst-mbi-3" data-swiper-parallax-y="60" data-swiper-parallax-opacity="0" data-swiper-parallax-duration="1000">
                            <?php if ( $item['image']['url'] && $settings['show_item_image'] == 'yes' ) : $image = wp_get_attachment_image_url( $item['image']['id'], 'tastyc_700x456' ); $image_full = wp_get_attachment_image_url( $item['image']['id'], 'tastyc_1920xAuto' ); ?>
                            <a<?php if ( ! $theme_lightbox ) : ?> data-magnific-gallery<?php endif; ?> data-elementor-lightbox-slideshow="gallery-<?php echo esc_attr( $category['id'] ); ?>" data-elementor-lightbox-title="<?php echo esc_attr( $item['title'] ); ?>" href="<?php echo esc_url( $image_full ); ?>" class="tst-item-cover-frame tst-cursor-zoom">
                              <img src="<?php echo esc_url( $image ); ?>" alt="<?php echo esc_attr( $item['title'] ); ?>">
                              <span class="tst-overlay"></span>
                            </a>
                            <?php endif; ?>
                            <div class="tst-menu-book-descr">
                              <div class="tst-menu-book-name">
                                <h5 class="tst-mb-15">
                             		<span <?php echo $this->get_render_attribute_string( $item_title ); ?>>
							          	<?php echo wp_kses_post( $item['title'] ); ?>
							        </span>
                                </h5>
                                <?php if ( $settings['show_item_desc'] == 'yes' ) : ?>
                                <div class="tst-text">
                                	<span <?php echo $this->get_render_attribute_string( $item_description ); ?>>
							          	<?php echo wp_kses_post( $item['description'] ); ?>
							        </span>
                                </div>
                            	<?php endif; ?>
                                <div class="tst-spacer-sm"></div>
                              </div>
                              <?php if ( $settings['show_item_price'] == 'yes' ) : ?>
                              <div class="tst-menu-book-bottom">
                                <div class="tst-menu-book-price">
                                  <div class="tst-price">
                                  	<span <?php echo $this->get_render_attribute_string( $item_price ); ?>>
							          	<?php echo wp_kses_post( $item['price'] ); ?>
							        </span>
                                  </div>
                                </div>
                              </div>
                              <?php endif; ?>
                            </div>
                          </div>

                        </div>
                        <?php endif; ?>
                    	<?php endforeach; ?>
                      </div>
                      <?php endif; ?>
                    </div>
                    <?php endforeach; ?>

                  </div>

                </div>

                <?php endif; ?>

              </div>

            </div>

            <?php else : ?>

            <div class="tst-menu-rows">
            <?php foreach ( $settings['categories'] as $index => $category ) :
				$category_title = $this->get_repeater_setting_key( 'title', 'categories', $index );
				$this->add_inline_editing_attributes( $category_title, 'basic' );

				$category_subtitle = $this->get_repeater_setting_key( 'subtitle', 'categories', $index );
				$this->add_inline_editing_attributes( $category_subtitle, 'basic' );

				$category_desc = $this->get_repeater_setting_key( 'description', 'categories', $index );
				$this->add_inline_editing_attributes( $category_desc, 'basic' );
			?>

			<div class="row">
              <div class="col-lg-12">

                <!-- title -->
                <div class="text-center">
                  <?php if ( $category['subtitle'] ) : ?>
                  <div class="tst-suptitle tst-suptitle-center tst-mb-15">
                  	<span <?php echo $this->get_render_attribute_string( $category_subtitle ); ?>>
			          	<?php echo wp_kses_post( $category['subtitle'] ); ?>
			        </span>
                  </div>
                  <?php endif; ?>
                  <?php if ( $category['title'] ) : ?>
                  <h3 class="tst-title--h tst-mb-30">
                  	<span <?php echo $this->get_render_attribute_string( $category_title ); ?>>
			          	<?php echo wp_kses_post( $category['title'] ); ?>
			        </span>
                  </h3>
                  <?php endif; ?>
                  <?php if ( $category['description'] ) : ?>
                  <p class="tst-text tst-text--description tst-mb-60">
                  	<span <?php echo $this->get_render_attribute_string( $category_desc ); ?>>
			          	<?php echo wp_kses_post( $category['description'] ); ?>
			        </span>
                  </p>
                  <?php endif; ?>
                </div>
                <!-- title end -->

              </div>

              <?php if ( $settings['items'] ) : ?>
              <?php foreach ( $settings['items'] as $index => $item ) :
              	$item_title = $this->get_repeater_setting_key( 'title', 'items', $index );
		  	    $this->add_inline_editing_attributes( $item_title, 'basic' );

		  	    $item_description = $this->get_repeater_setting_key( 'description', 'items', $index );
		  	    $this->add_inline_editing_attributes( $item_description, 'basic' );

		  	    $item_price = $this->get_repeater_setting_key( 'price', 'items', $index );
		  	    $this->add_inline_editing_attributes( $item_price, 'basic' );
              ?>
              <?php if ( $category['id'] == $item['category'] || $item['category'] == 'all' ) : ?>
                <div class="col-lg-6">

                  <div class="tst-menu-book-item tst-mbi-3" data-swiper-parallax-y="60" data-swiper-parallax-opacity="0" data-swiper-parallax-duration="1000">
	                <?php if ( $item['image']['url'] && $settings['show_item_image'] == 'yes' ) : $image = wp_get_attachment_image_url( $item['image']['id'], 'tastyc_700x456' ); $image_full = wp_get_attachment_image_url( $item['image']['id'], 'tastyc_1920xAuto' ); ?>
                    <a<?php if ( ! $theme_lightbox ) : ?> data-magnific-gallery<?php endif; ?> data-elementor-lightbox-slideshow="gallery-<?php echo esc_attr( $category['id'] ); ?>" data-elementor-lightbox-title="<?php echo esc_attr( $item['title'] ); ?>" href="<?php echo esc_url( $image_full ); ?>" class="tst-item-cover-frame tst-cursor-zoom">
                      <img src="<?php echo esc_url( $image ); ?>" alt="<?php echo esc_attr( $item['title'] ); ?>">
                      <span class="tst-overlay"></span>
                    </a>
                    <?php endif; ?>
                    <div class="tst-menu-book-descr">
                      <div class="tst-menu-book-name">
                        <h5 class="tst-mb-15">
                        	<span <?php echo $this->get_render_attribute_string( $item_title ); ?>>
					          	<?php echo wp_kses_post( $item['title'] ); ?>
					        </span>
                        </h5>
                        <?php if ( $settings['show_item_desc'] == 'yes' ) : ?>
                        <div class="tst-text">
                        	<span <?php echo $this->get_render_attribute_string( $item_description ); ?>>
					          	<?php echo wp_kses_post( $item['description'] ); ?>
					        </span>
                        </div>
                    	<?php endif; ?>
                        <div class="tst-spacer-sm"></div>
                      </div>
                      <?php if ( $settings['show_item_price'] == 'yes' ) : ?>
                      <div class="tst-menu-book-bottom">
                        <div class="tst-menu-book-price">
                          <div class="tst-price">
                          	<span <?php echo $this->get_render_attribute_string( $item_price ); ?>>
					          	<?php echo wp_kses_post( $item['price'] ); ?>
					        </span>
                          </div>
                        </div>
                      </div>
                      <?php endif; ?>
                    </div>
                  </div>

                </div>
                <?php endif; ?>
              <?php endforeach; ?>
              <?php endif; ?>

              </div>

              <div class="tst-spacer tst-spacer-only-bottom-space"></div>

              <?php endforeach; ?>

              </div>
            <?php endif; ?>
        </div>

		<!-- container end -->

		<?php
	}
}

Plugin::instance()->widgets_manager->register( new Tastyc_Menu_Simple_Widget() );
