<?php
namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

/**
 * Tastyc Menu Widget.
 *
 * @since 1.0
 */
class Tastyc_Menu_Widget extends Widget_Base {

	public function get_name() {
		return 'tastyc-menu';
	}

	public function get_title() {
		return esc_html__( 'Menu (WC Products)', 'tastyc-plugin' );
	}

	public function get_icon() {
		return 'eicon-parallax';
	}

	public function get_categories() {
		return [ 'tastyc-category' ];
	}

	/**
	 * Register widget controls.
	 *
	 * @since 1.0
	 */
	protected function register_controls() {

		$this->start_controls_section(
			'items_tab',
			[
				'label' => esc_html__( 'Menu Categories', 'tastyc-plugin' ),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
		);

		$repeater = new \Elementor\Repeater();

		$repeater->add_control(
			'source', [
				'label'       => esc_html__( 'Source', 'ryancv-plugin' ),
				'type'        => Controls_Manager::SELECT,
				'default' => 'all',
				'options' => [
					'all'  => __( 'All', 'ryancv-plugin' ),
					'categories' => __( 'Product Categories', 'ryancv-plugin' ),
					'tags' => __( 'Product Tags', 'ryancv-plugin' ),
					'custom' => __( 'Custom Products', 'ryancv-plugin' ),
				],
			]
		);

		$repeater->add_control(
			'source_categories', [
				'label'       => esc_html__( 'Categories', 'ryancv-plugin' ),
				'type'        => Controls_Manager::SELECT2,
				'label_block' => true,
				'multiple' => true,
				'options' => $this->get_products_categories(),
				'condition' => [
		            'source' => 'categories'
		        ],
			]
		);

		$repeater->add_control(
			'source_tags', [
				'label'       => esc_html__( 'Tags', 'ryancv-plugin' ),
				'type'        => Controls_Manager::SELECT2,
				'label_block' => true,
				'multiple' => true,
				'options' => $this->get_products_tags(),
				'condition' => [
		            'source' => 'tags'
		        ],
			]
		);

		$repeater->add_control(
			'source_custom', [
				'label'       => esc_html__( 'Custom Products', 'ryancv-plugin' ),
				'type'        => Controls_Manager::SELECT2,
				'label_block' => true,
				'multiple' => true,
				'options' => $this->get_products_custom(),
				'condition' => [
		            'source' => 'custom'
		        ],
			]
		);

		$repeater->add_control(
			'title', [
				'label'       => esc_html__( 'Title', 'tastyc-plugin' ),
				'type'        => Controls_Manager::TEXTAREA,
				'placeholder' => esc_html__( 'Enter title', 'tastyc-plugin' ),
				'default'     => esc_html__( 'Title', 'tastyc-plugin' ),
			]
		);

		$repeater->add_control(
			'subtitle', [
				'label'       => esc_html__( 'Subtitle', 'tastyc-plugin' ),
				'type'        => Controls_Manager::TEXTAREA,
				'placeholder' => esc_html__( 'Enter subtitle', 'tastyc-plugin' ),
				'default'     => esc_html__( 'Subtitle', 'tastyc-plugin' ),
			]
		);

		$repeater->add_control(
			'description', [
				'label'       => esc_html__( 'Description', 'tastyc-plugin' ),
				'type'        => Controls_Manager::TEXTAREA,
				'placeholder' => esc_html__( 'Enter description', 'tastyc-plugin' ),
				'default'     => esc_html__( 'Description', 'tastyc-plugin' ),
			]
		);

		$this->add_control(
			'items',
			[
				'label' => esc_html__( 'Items', 'tastyc-plugin' ),
				'type' => Controls_Manager::REPEATER,
				'prevent_empty' => false,
				'fields' => $repeater->get_controls(),
				'title_field' => '{{{ title }}}',
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'list_settings_tab',
			[
				'label' => esc_html__( 'List Settings', 'tastyc-plugin' ),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'layout',
			[
				'label'       => esc_html__( 'Layout', 'tastyc-plugin' ),
				'type'        => Controls_Manager::SELECT,
				'default' => 'list',
				'options' => [
					'list'  => __( 'List', 'tastyc-plugin' ),
					'tabs' => __( 'Tabs', 'tastyc-plugin' ),
				],
			]
		);

		$this->add_control(
			'show_cat_desc',
			[
				'label' => esc_html__( 'Show Description in Tabs layout?', 'tastyc-plugin' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => __( 'Show', 'tastyc-plugin' ),
				'label_off' => __( 'Hide', 'tastyc-plugin' ),
				'return_value' => 'yes',
				'default' => 'no',
				'condition' => [
		            'layout' => 'tabs'
		        ],
			]
		);

		$this->add_control(
			'limit',
			[
				'label'       => esc_html__( 'Number of Items', 'tastyc-plugin' ),
				'type'        => Controls_Manager::NUMBER,
				'placeholder' => 8,
				'default'     => 8,
			]
		);

		$this->add_control(
			'sort',
			[
				'label'       => esc_html__( 'Sorting By', 'tastyc-plugin' ),
				'type'        => Controls_Manager::SELECT,
				'default' => 'menu_order',
				'options' => [
					'date'  => __( 'Date', 'tastyc-plugin' ),
					'title' => __( 'Title', 'tastyc-plugin' ),
					'rand' => __( 'Random', 'tastyc-plugin' ),
					'menu_order' => __( 'Order', 'tastyc-plugin' ),
				],
			]
		);

		$this->add_control(
			'order',
			[
				'label'       => esc_html__( 'Order', 'tastyc-plugin' ),
				'type'        => Controls_Manager::SELECT,
				'default' => 'asc',
				'options' => [
					'asc'  => __( 'ASC', 'tastyc-plugin' ),
					'desc' => __( 'DESC', 'tastyc-plugin' ),
				],
			]
		);

		$this->end_controls_section();


		$this->start_controls_section(
			'item_settings_tab',
			[
				'label' => esc_html__( 'Item Settings', 'tastyc-plugin' ),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'show_item_buy_button',
			[
				'label' => esc_html__( 'Show Item Add to Cart?', 'tastyc-plugin' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => __( 'Show', 'tastyc-plugin' ),
				'label_off' => __( 'Hide', 'tastyc-plugin' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);

		$this->add_control(
			'show_item_desc',
			[
				'label' => esc_html__( 'Show Item Description?', 'tastyc-plugin' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => __( 'Show', 'tastyc-plugin' ),
				'label_off' => __( 'Hide', 'tastyc-plugin' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);

		$this->add_control(
			'show_item_link',
			[
				'label' => esc_html__( 'Show Item Link?', 'tastyc-plugin' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => __( 'Show', 'tastyc-plugin' ),
				'label_off' => __( 'Hide', 'tastyc-plugin' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'heading_styling',
			[
				'label'     => esc_html__( 'Heading', 'tastyc-plugin' ),
				'tab'       => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'subtitle_color',
			[
				'label'     => esc_html__( 'Subtitle Color', 'tastyc-plugin' ),
				'type'      => Controls_Manager::COLOR,
				'default'	=> '',
				'selectors' => [
					'{{WRAPPER}} .row .tst-suptitle' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'     => 'subtitle_typography',
				'label'     => esc_html__( 'Subtitle Typography', 'tastyc-plugin' ),
				'selector' => '{{WRAPPER}} .row .tst-suptitle',
			]
		);

		$this->add_control(
			'title_color',
			[
				'label'     => esc_html__( 'Title Color', 'tastyc-plugin' ),
				'type'      => Controls_Manager::COLOR,
				'default'	=> '',
				'selectors' => [
					'{{WRAPPER}} .row .tst-title--h' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'     => 'title_typography',
				'label'     => esc_html__( 'Title Typography', 'tastyc-plugin' ),
				'selector' => '{{WRAPPER}} .row .tst-title--h',
			]
		);

		$this->add_control(
			'desc_color',
			[
				'label'     => esc_html__( 'Description Color', 'tastyc-plugin' ),
				'type'      => Controls_Manager::COLOR,
				'default'	=> '',
				'selectors' => [
					'{{WRAPPER}} .row .tst-text--description' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'     => 'desc_typography',
				'label'     => esc_html__( 'Description Typography', 'tastyc-plugin' ),
				'selector' => '{{WRAPPER}} .row .tst-text--description',
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'tabs_styling',
			[
				'label'     => esc_html__( 'Tabs Link', 'tastyc-plugin' ),
				'tab'       => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'tabs_color',
			[
				'label'     => esc_html__( 'Link Color', 'tastyc-plugin' ),
				'type'      => Controls_Manager::COLOR,
				'default'	=> '',
				'selectors' => [
					'{{WRAPPER}} .swiper-menu-nav .swiper-pagination-bullet' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'tabs_active_color',
			[
				'label'     => esc_html__( 'Active Link Color', 'tastyc-plugin' ),
				'type'      => Controls_Manager::COLOR,
				'default'	=> '',
				'selectors' => [
					'{{WRAPPER}} .swiper-menu-nav .swiper-pagination-bullet-active' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'tabs_active_bgcolor',
			[
				'label'     => esc_html__( 'Active Link BG Color', 'tastyc-plugin' ),
				'type'      => Controls_Manager::COLOR,
				'default'	=> '',
				'selectors' => [
					'{{WRAPPER}} .swiper-menu-nav .swiper-pagination-bullet-active' => 'background-color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'     => 'filters_typography',
				'label'     => esc_html__( 'Tabs Typography', 'tastyc-plugin' ),
				'selector' => '{{WRAPPER}} .swiper-menu-nav .swiper-pagination-bullet',
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'items_styling',
			[
				'label'     => esc_html__( 'Items', 'tastyc-plugin' ),
				'tab'       => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'item_bg_color',
			[
				'label'     => esc_html__( 'Item BG Color', 'tastyc-plugin' ),
				'type'      => Controls_Manager::COLOR,
				'default'	=> '',
				'selectors' => [
					'{{WRAPPER}} .tst-menu-book-item' => 'background-color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'item_title_color',
			[
				'label'     => esc_html__( 'Title Color', 'tastyc-plugin' ),
				'type'      => Controls_Manager::COLOR,
				'default'	=> '',
				'selectors' => [
					'{{WRAPPER}} .tst-menu-book-name h5' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'     => 'item_title_typography',
				'label'     => esc_html__( 'Title Typography', 'tastyc-plugin' ),
				'selector' => '{{WRAPPER}} .tst-menu-book-name h5',
			]
		);

		$this->add_control(
			'item_text_color',
			[
				'label'     => esc_html__( 'Text Color', 'tastyc-plugin' ),
				'type'      => Controls_Manager::COLOR,
				'default'	=> '',
				'selectors' => [
					'{{WRAPPER}} .tst-menu-book-name .tst-text' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'     => 'item_text_typography',
				'label'     => esc_html__( 'Text Typography', 'tastyc-plugin' ),
				'selector' => '{{WRAPPER}} .tst-menu-book-name .tst-text',
			]
		);

		$this->add_control(
			'item_price_color',
			[
				'label'     => esc_html__( 'Price Color', 'tastyc-plugin' ),
				'type'      => Controls_Manager::COLOR,
				'default'	=> '',
				'selectors' => [
					'{{WRAPPER}} .tst-menu-book-price .tst-price' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'     => 'item_price_typography',
				'label'     => esc_html__( 'Price Typography', 'tastyc-plugin' ),
				'selector' => '{{WRAPPER}} .tst-menu-book-price .tst-price',
			]
		);

		$this->add_control(
			'item_btn_color',
			[
				'label'     => esc_html__( 'Button Color', 'tastyc-plugin' ),
				'type'      => Controls_Manager::COLOR,
				'default'	=> '',
				'selectors' => [
					'{{WRAPPER}} .tst-menu-book-bottom .tst-btn svg path' => 'fill: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'item_btn_bgcolor',
			[
				'label'     => esc_html__( 'Button BG Color', 'tastyc-plugin' ),
				'type'      => Controls_Manager::COLOR,
				'default'	=> '',
				'selectors' => [
					'{{WRAPPER}} .tst-menu-book-bottom .tst-btn' => 'background-color: {{VALUE}};',
				],
			]
		);

		$this->end_controls_section();
	}

	/**
	 * Render Categories List.
	 *
	 * @since 1.0
	 */
	protected function get_products_categories() {
		$categories = [];

		$args = array(
			'type'			=> 'product',
			'child_of'		=> 0,
			'parent'		=> '',
			'orderby'		=> 'name',
			'order'			=> 'DESC',
			'hide_empty'	=> 1,
			'hierarchical'	=> 1,
			'taxonomy'		=> 'product_cat',
			'pad_counts'	=> false
		);

		$products_categories = get_categories( $args );

		foreach ( $products_categories as $category ) {
			$categories[$category->term_id] = $category->name;
		}

		return $categories;
	}

	protected function get_products_tags() {
		$tags = [];

		$args = array(
			'type'			=> 'product',
			'child_of'		=> 0,
			'parent'		=> '',
			'orderby'		=> 'name',
			'order'			=> 'DESC',
			'hide_empty'	=> 1,
			'hierarchical'	=> 1,
			'taxonomy'		=> 'product_tag',
			'pad_counts'	=> false
		);

		$products_tags = get_categories( $args );

		foreach ( $products_tags as $tag ) {
			$tags[$tag->term_id] = $tag->name;
		}

		return $tags;
	}

	protected function get_products_custom() {
		$items = [];

		$args = array(
			'post_type'			=> 'product',
			'post_status'		=> 'publish',
			'posts_per_page'	=> -1
		);

		$products_items = new \WP_Query( $args );

		while ( $products_items->have_posts() ) : $products_items->the_post();
			$items[get_the_ID()] = get_the_title();
		endwhile; wp_reset_postdata();

		return $items;
	}

	/**
	 * Render widget output on the frontend.
	 *
	 * @since 1.0
	 */
	protected function render() {
		$settings = $this->get_settings_for_display();

		$theme_lightbox = get_field( 'portfolio_lightbox_disable', 'option' );

		?>

		<!-- container -->
		<div class="container swiper-menu-container">

			<?php if ( $settings['layout'] == 'tabs' ) : ?>

			<div class="row">


			  <?php if ( $settings['items'] ) : ?>
              <div class="col-lg-12">
                <div class="swiper-menu-nav">
                	<?php foreach ( $settings['items'] as $index => $item ) :
					  $item_title = $this->get_repeater_setting_key( 'title', 'items', $index );
					  $this->add_inline_editing_attributes( $item_title, 'basic' );
					?>
                	<span class="span-category">
                		<span <?php echo $this->get_render_attribute_string( $item_title ); ?>>
				          	<?php echo wp_kses_post( $item['title'] ); ?>
				         </span>
                	</span>
                	<?php endforeach; ?>
                </div>

                <div class="tst-spacer tst-spacer-only-bottom-space"></div>

              </div>
              <?php endif; ?>

              <?php if ( $settings['items'] ) : ?>
              <div class="col-lg-12">
                <!-- Slider main container -->
                <div class="swiper-container swiper-menu">
                  <!-- Additional required wrapper -->
                  <div class="swiper-wrapper">
                    <!-- Slides -->
                    <?php $cat_i = 0; foreach ( $settings['items'] as $index => $item ) :

											$cat_i++;

											$category_title = $this->get_repeater_setting_key( 'title', 'categories', $index );
											$this->add_inline_editing_attributes( $category_title, 'basic' );

											$category_subtitle = $this->get_repeater_setting_key( 'subtitle', 'categories', $index );
											$this->add_inline_editing_attributes( $category_subtitle, 'basic' );

											$category_desc = $this->get_repeater_setting_key( 'description', 'categories', $index );
											$this->add_inline_editing_attributes( $category_desc, 'basic' );

										?>

                    <div class="swiper-slide">

                      <?php

                      $args = array(
						'post_type'			=> 'product',
						'post_status'		=> 'publish',
						'orderby'			=> $settings['sort'],
						'order'				=> $settings['order'],
						'posts_per_page'	=> $settings['limit'],
						'paged' 			=> 1
					  );

                      if ( $item['source'] == 'categories' ) {
						$ids = $item['source_categories'];
					  } elseif ( $item['source'] == 'tags' ) {
						$ids = $item['source_tags'];
					  } elseif ( $item['source'] == 'custom' ) {
						$ids = $item['source_custom'];
					  } else {
						$ids = false;
					  }

                  	  if ( $item['source'] == 'categories' ) {
						$tax_array = array(
							array(
								'taxonomy' => 'product_cat',
								'field'    => 'id',
								'terms'    => $ids
							)
						);

						$args += array('tax_query' => $tax_array);
					  }
					  if ( $item['source'] == 'tags' ) {
						$tax_array = array(
							array(
								'taxonomy' => 'product_tag',
								'field'    => 'id',
								'terms'    => $ids
							)
						);

						$args += array('tax_query' => $tax_array);
					  }
					  if ( $item['source'] == 'custom' ) {
						$args += array( 'post__in' => $ids );
					  }

					  $products_loop = new \WP_Query( $args );

					  if ( class_exists( 'WooCommerce' ) ) :
                      if ( $products_loop->have_posts() ) : ?>
                      <div class="row">

												<?php if ( $settings['show_cat_desc'] == 'yes' ) : ?>
												<div class="col-lg-12">

					                <!-- title -->
					                <div class="text-center">
					                  <?php if ( $item['subtitle'] ) : ?>
					                  <div class="tst-suptitle tst-suptitle-center tst-mb-15">
					                  	<span <?php echo $this->get_render_attribute_string( $category_subtitle ); ?>>
								          	<?php echo wp_kses_post( $item['subtitle'] ); ?>
								        </span>
					                  </div>
					                  <?php endif; ?>
					                  <?php if ( $item['title'] ) : ?>
					                  <h3 class="tst-title--h tst-mb-30">
					                  	<span <?php echo $this->get_render_attribute_string( $category_title ); ?>>
								          	<?php echo wp_kses_post( $item['title'] ); ?>
								        </span>
					                  </h3>
					                  <?php endif; ?>
					                  <?php if ( $item['description'] ) : ?>
					                  <p class="tst-text tst-text--description tst-mb-60">
					                  	<span <?php echo $this->get_render_attribute_string( $category_desc ); ?>>
								          	<?php echo wp_kses_post( $item['description'] ); ?>
								        </span>
					                  </p>
					                  <?php endif; ?>
					                </div>
					                <!-- title end -->

					              </div>
												<?php endif; ?>

                      	<?php while ( $products_loop->have_posts() ) : $products_loop->the_post();
                      	$product_id = get_the_ID();
                      	global $product;
						$product = wc_get_product( $product_id );
						$image_full = get_the_post_thumbnail_url( $product_id, 'tastyc_1920xAuto' );
						$image = get_the_post_thumbnail_url( $product_id, 'tastyc_700x456' );
						$title = get_the_title( $product_id );
						$text = get_the_excerpt( $product_id );
						$href = get_the_permalink( $product_id );
						?>
                        <div class="col-lg-6">

                          <div class="tst-menu-book-item tst-mbi-3" data-swiper-parallax-y="60" data-swiper-parallax-opacity="0" data-swiper-parallax-duration="1000">
                            <?php if ( $image ) : ?>
                            <a<?php if ( ! $theme_lightbox ) : ?> data-magnific-gallery<?php endif; ?> data-elementor-lightbox-slideshow="gallery-<?php echo esc_attr( $cat_i ); ?>" data-elementor-lightbox-title="<?php echo esc_attr( $title ); ?>" href="<?php echo esc_url( $image_full ); ?>" class="tst-item-cover-frame tst-cursor-zoom">
                              <img src="<?php echo esc_url( $image ); ?>" alt="<?php echo esc_attr( $title ); ?>">
                              <span class="tst-overlay"></span>
                            </a>
       	                    <?php endif; ?>
                            <div class="tst-menu-book-descr">
                              <div class="tst-menu-book-name">
                                <h5 class="tst-mb-15">
                                	<?php if ( $settings['show_item_link'] == 'yes' ) : ?><a href="<?php echo esc_url( $href ); ?>"><?php endif; ?>
                                	<?php echo wp_kses_post( $title ); ?>
                                	<?php if ( $settings['show_item_link'] == 'yes' ) : ?></a><?php endif; ?>
                                </h5>
                                <?php if ( $settings['show_item_desc'] == 'yes' ) : ?>
                                <div class="tst-text"><?php echo wp_kses_post( $text ); ?></div>
                            	<?php endif; ?>
                                <div class="tst-spacer-sm"></div>
                              </div>
                              <div class="tst-menu-book-bottom">
                                <div class="tst-menu-book-price">
                                  <div class="tst-price">
                                  	<?php echo wc_price( $product->get_price() ); ?>
                                  </div>
                                </div>
                                <?php if ( $settings['show_item_buy_button'] == 'yes' ) : ?>
                                <a href="?add-to-cart=<?php echo esc_attr( $product_id ); ?>" class="tst-btn tst-cart-btn product_type_simple ajax_add_to_cart add_to_cart_button" data-product_id="<?php echo esc_attr( $product_id ); ?>" title="<?php echo esc_attr__( 'Add to Cart', 'tastyc-plugin' ); ?>">
                                  <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 128 128">
                                    <path
                                      d="M87.7,33.1l-0.8-10.8C86,10.4,76,1,64,1s-22.1,9.4-22.9,21.3l-0.8,10.8H28.8c-4.7,0-8.6,3.7-9,8.4l-5.4,75.9c0,0,0,0,0,0 c-0.2,2.5,0.7,5,2.4,6.8s4.1,2.9,6.6,2.9h81.3c2.5,0,4.9-1,6.6-2.9c1.7-1.8,2.6-4.3,2.4-6.8l-5.4-75.2c-0.4-5.1-4.6-9-9.7-9H87.7z M47.1,22.7C47.7,13.9,55.1,7,64,7s16.3,6.9,16.9,15.7l0.7,10.4H46.3L47.1,22.7z M102.3,42.6l5.4,75.2c0.1,0.8-0.2,1.6-0.8,2.3 c-0.6,0.6-1.4,1-2.2,1H23.4c-0.8,0-1.6-0.3-2.2-1s-0.9-1.4-0.8-2.3h0l5.4-75.9c0.1-1.6,1.4-2.8,3-2.8h11.1l-0.6,8 c-0.1,1.7,1.1,3.1,2.8,3.2c0.1,0,0.1,0,0.2,0c1.6,0,2.9-1.2,3-2.8l0.6-8.4h36.2l0.6,8.4c0.1,1.7,1.5,2.9,3.2,2.8 c1.7-0.1,2.9-1.5,2.8-3.2l-0.6-8h10.5C100.5,39.1,102.1,40.6,102.3,42.6z" />
                                  </svg>
                                </a>
                            	<?php endif; ?>
                              </div>
                            </div>
                          </div>

                        </div>
                    	<?php endwhile; ?>
                      </div>
                      <?php endif; wp_reset_postdata(); endif; ?>
                    </div>
                    <?php endforeach; ?>

                  </div>

                </div>

                <?php endif; ?>

              </div>

            </div>

            <?php else : ?>

            <div class="tst-menu-rows">
            <?php $cat_i = 0; foreach ( $settings['items'] as $index => $item ) : $cat_i++;
				  $item_title = $this->get_repeater_setting_key( 'title', 'items', $index );
				  $this->add_inline_editing_attributes( $item_title, 'basic' );

				  $item_subtitle = $this->get_repeater_setting_key( 'subtitle', 'items', $index );
				  $this->add_inline_editing_attributes( $item_subtitle, 'basic' );

				  $item_desc = $this->get_repeater_setting_key( 'description', 'items', $index );
				  $this->add_inline_editing_attributes( $item_desc, 'basic' );
			?>

			<div class="row">
              <div class="col-lg-12">

                <!-- title -->
                <div class="text-center">
                  <?php if ( $item['subtitle'] ) : ?>
                  <div class="tst-suptitle tst-suptitle-center tst-mb-15">
                  	<span <?php echo $this->get_render_attribute_string( $item_subtitle ); ?>>
			          	<?php echo wp_kses_post( $item['subtitle'] ); ?>
			        </span>
                  </div>
                  <?php endif; ?>
                  <?php if ( $item['title'] ) : ?>
                  <h3 class="tst-title--h tst-mb-30">
                  	<span <?php echo $this->get_render_attribute_string( $item_title ); ?>>
			          	<?php echo wp_kses_post( $item['title'] ); ?>
			        </span>
                  </h3>
                  <?php endif; ?>
                  <?php if ( $item['description'] ) : ?>
                  <p class="tst-text tst-text--description tst-mb-60">
                  	<span <?php echo $this->get_render_attribute_string( $item_desc ); ?>>
			          	<?php echo wp_kses_post( $item['description'] ); ?>
			        </span>
                  </p>
                  <?php endif; ?>
                </div>
                <!-- title end -->

              </div>

              <?php

              $args = array(
				'post_type'			=> 'product',
				'post_status'		=> 'publish',
				'orderby'			=> $settings['sort'],
				'order'				=> $settings['order'],
				'posts_per_page'	=> $settings['limit'],
				'paged' 			=> 1
			  );

              if ( $item['source'] == 'categories' ) {
				$ids = $item['source_categories'];
			  } elseif ( $item['source'] == 'tags' ) {
				$ids = $item['source_tags'];
			  } elseif ( $item['source'] == 'custom' ) {
				$ids = $item['source_custom'];
			  } else {
				$ids = false;
			  }

          	  if ( $item['source'] == 'categories' ) {
				$tax_array = array(
					array(
						'taxonomy' => 'product_cat',
						'field'    => 'id',
						'terms'    => $ids
					)
				);

				$args += array('tax_query' => $tax_array);
			  }
			  if ( $item['source'] == 'tags' ) {
				$tax_array = array(
					array(
						'taxonomy' => 'product_tag',
						'field'    => 'id',
						'terms'    => $ids
					)
				);

				$args += array('tax_query' => $tax_array);
			  }
			  if ( $item['source'] == 'custom' ) {
				$args += array( 'post__in' => $ids );
			  }

			  $products_loop = new \WP_Query( $args );

			  if ( class_exists( 'WooCommerce' ) ) :
              if ( $products_loop->have_posts() ) :

              while ( $products_loop->have_posts() ) : $products_loop->the_post();
              	$product_id = get_the_ID();
              	global $product;
				$product = wc_get_product( $product_id );
				$image_full = get_the_post_thumbnail_url( $product_id, 'tastyc_1920xAuto' );
				$image = get_the_post_thumbnail_url( $product_id, 'tastyc_700x456' );
				$title = get_the_title( $product_id );
				$href = get_the_permalink( $product_id );
				$text = get_the_excerpt( $product_id );
			  ?>
                <div class="col-lg-6">

                  <div class="tst-menu-book-item tst-mbi-3" data-swiper-parallax-y="60" data-swiper-parallax-opacity="0" data-swiper-parallax-duration="1000">
                    <?php if ( $image ) : ?>
                    <a<?php if ( ! $theme_lightbox ) : ?> data-magnific-gallery<?php endif; ?> data-elementor-lightbox-slideshow="gallery-<?php echo esc_attr( $cat_i ); ?>" data-elementor-lightbox-title="<?php echo esc_attr( $title ); ?>" href="<?php echo esc_url( $image_full ); ?>" class="tst-item-cover-frame tst-cursor-zoom">
                      <img src="<?php echo esc_url( $image ); ?>" alt="<?php echo esc_attr( $title ); ?>">
                      <span class="tst-overlay"></span>
                    </a>
	                <?php endif; ?>
                    <div class="tst-menu-book-descr">
                      <div class="tst-menu-book-name">
                        <h5 class="tst-mb-15">
                        	<?php if ( $settings['show_item_link'] == 'yes' ) : ?><a href="<?php echo esc_url( $href ); ?>"><?php endif; ?>
                        	<?php echo wp_kses_post( $title ); ?>
                        	<?php if ( $settings['show_item_link'] == 'yes' ) : ?></a><?php endif; ?>
                        </h5>
                        <?php if ( $settings['show_item_desc'] == 'yes' ) : ?>
                        <div class="tst-text"><?php echo wp_kses_post( $text ); ?></div>
                    	<?php endif; ?>
                        <div class="tst-spacer-sm"></div>
                      </div>
                      <div class="tst-menu-book-bottom">
                        <div class="tst-menu-book-price">
                          <div class="tst-price">
                          	<?php echo wc_price( $product->get_price() ); ?>
                          </div>
                        </div>
                        <?php if ( $settings['show_item_buy_button'] == 'yes' ) : ?>
                        <a href="?add-to-cart=<?php echo esc_attr( $product_id ); ?>" class="tst-btn tst-cart-btn product_type_simple ajax_add_to_cart add_to_cart_button" data-product_id="<?php echo esc_attr( $product_id ); ?>" title="<?php echo esc_attr__( 'Add to Cart', 'tastyc-plugin' ); ?>">
                          <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 128 128">
                            <path
                              d="M87.7,33.1l-0.8-10.8C86,10.4,76,1,64,1s-22.1,9.4-22.9,21.3l-0.8,10.8H28.8c-4.7,0-8.6,3.7-9,8.4l-5.4,75.9c0,0,0,0,0,0 c-0.2,2.5,0.7,5,2.4,6.8s4.1,2.9,6.6,2.9h81.3c2.5,0,4.9-1,6.6-2.9c1.7-1.8,2.6-4.3,2.4-6.8l-5.4-75.2c-0.4-5.1-4.6-9-9.7-9H87.7z M47.1,22.7C47.7,13.9,55.1,7,64,7s16.3,6.9,16.9,15.7l0.7,10.4H46.3L47.1,22.7z M102.3,42.6l5.4,75.2c0.1,0.8-0.2,1.6-0.8,2.3 c-0.6,0.6-1.4,1-2.2,1H23.4c-0.8,0-1.6-0.3-2.2-1s-0.9-1.4-0.8-2.3h0l5.4-75.9c0.1-1.6,1.4-2.8,3-2.8h11.1l-0.6,8 c-0.1,1.7,1.1,3.1,2.8,3.2c0.1,0,0.1,0,0.2,0c1.6,0,2.9-1.2,3-2.8l0.6-8.4h36.2l0.6,8.4c0.1,1.7,1.5,2.9,3.2,2.8 c1.7-0.1,2.9-1.5,2.8-3.2l-0.6-8h10.5C100.5,39.1,102.1,40.6,102.3,42.6z" />
                          </svg>
                        </a>
                    	<?php endif; ?>
                      </div>
                    </div>
                  </div>

                </div>
              <?php endwhile; ?>

              <?php endif; wp_reset_postdata(); endif; ?>

              </div>

              <div class="tst-spacer tst-spacer-only-bottom-space"></div>

              <?php endforeach; ?>

              </div>
            <?php endif; ?>
        </div>

		<!-- container end -->

		<?php
	}
}

Plugin::instance()->widgets_manager->register( new Tastyc_Menu_Widget() );
