<?php
namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

/**
 * Tastyc Numbers Widget.
 *
 * @since 1.0
 */
class Tastyc_Numbers_Widget extends Widget_Base {

	public function get_name() {
		return 'tastyc-numbers';
	}

	public function get_title() {
		return esc_html__( 'Numbers', 'tastyc-plugin' );
	}

	public function get_icon() {
		return 'eicon-parallax';
	}

	public function get_categories() {
		return [ 'tastyc-category' ];
	}

	/**
	 * Register widget controls.
	 *
	 * @since 1.0
	 */
	protected function register_controls() {

		$this->start_controls_section(
			'items_tab',
			[
				'label' => esc_html__( 'Items', 'tastyc-plugin' ),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
		);

		$repeater = new \Elementor\Repeater();

		$repeater->add_control(
			'value', [
				'label'       => esc_html__( 'Number Value', 'tastyc-plugin' ),
				'type'        => Controls_Manager::TEXT,
				'placeholder' => esc_html__( 'Enter number value', 'tastyc-plugin' ),
				'default'	=> 99,
			]
		);

		$repeater->add_control(
			'after', [
				'label'       => esc_html__( 'After Text', 'tastyc-plugin' ),
				'type'        => Controls_Manager::TEXT,
				'placeholder' => esc_html__( 'Enter after text', 'tastyc-plugin' ),
			]
		);

		$repeater->add_control(
			'label', [
				'label'       => esc_html__( 'Label', 'tastyc-plugin' ),
				'type'        => Controls_Manager::TEXTAREA,
				'placeholder' => esc_html__( 'Enter label', 'tastyc-plugin' ),
				'default'	=> esc_html__( 'Label', 'tastyc-plugin' ),
			]
		);

		$this->add_control(
			'items',
			[
				'label' => esc_html__( 'Numbers Items', 'tastyc-plugin' ),
				'type' => Controls_Manager::REPEATER,
				'prevent_empty' => false,
				'fields' => $repeater->get_controls(),
				'title_field' => '{{{ label }}}',
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'items_styling',
			[
				'label'     => esc_html__( 'Items', 'tastyc-plugin' ),
				'tab'       => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'item_value_color',
			[
				'label'     => esc_html__( 'Number Color', 'tastyc-plugin' ),
				'type'      => Controls_Manager::COLOR,
				'default'	=> '',
				'selectors' => [
					'{{WRAPPER}} .tst-count .tst-number' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'     => 'item_value_typography',
				'label'     => esc_html__( 'Number Typography', 'tastyc-plugin' ),
				'selector' => '{{WRAPPER}} .tst-count .tst-number',
			]
		);

		$this->add_control(
			'item_value_after_color',
			[
				'label'     => esc_html__( 'After Value Color', 'tastyc-plugin' ),
				'type'      => Controls_Manager::COLOR,
				'default'	=> '',
				'selectors' => [
					'{{WRAPPER}} .tst-count .tst-color' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'     => 'item_value_after_typography',
				'label'     => esc_html__( 'After Value Typography', 'tastyc-plugin' ),
				'selector' => '{{WRAPPER}} .tst-count .tst-color',
			]
		);

		$this->add_control(
			'item_label_color',
			[
				'label'     => esc_html__( 'Label Color', 'tastyc-plugin' ),
				'type'      => Controls_Manager::COLOR,
				'default'	=> '',
				'selectors' => [
					'{{WRAPPER}} .tst-count .tst-label' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'     => 'item_label_typography',
				'label'     => esc_html__( 'Label Typography', 'tastyc-plugin' ),
				'selector' => '{{WRAPPER}} .tst-count .tst-label',
			]
		);

		$this->end_controls_section();
	}


	/**
	 * Render widget output on the frontend.
	 *
	 * @since 1.0
	 */
	protected function render() {
		$settings = $this->get_settings_for_display();
		?>

		<!-- container -->
		<div class="container">
		<?php if ( $settings['items'] ) : ?>
		<div class="row">
		  <?php foreach ( $settings['items'] as $index => $item ) :
		  $item_value = $this->get_repeater_setting_key( 'value', 'items', $index );
		  $this->add_inline_editing_attributes( $item_value, 'none' );

		  $item_after = $this->get_repeater_setting_key( 'after', 'items', $index );
		  $this->add_inline_editing_attributes( $item_after, 'none' );

		  $item_label = $this->get_repeater_setting_key( 'label', 'items', $index );
		  $this->add_inline_editing_attributes( $item_label, 'basic' );
		  ?>
          <div class="col-sm-6 col-lg-3">

            <!-- counter -->
            <div class="tst-count tst-mb-70">
              <div class="h3 tst-mb-15">
              	<span class="tst-number" data-count="<?php echo esc_attr( $item['value'] ); ?>">0</span>
              	<span class="tst-color">
	          		<span <?php echo $this->get_render_attribute_string( $item_after ); ?>>
		        		<?php echo esc_html( $item['after'] ); ?>
		        	</span>
              	</span>
              </div>
              <div class="tst-label">
              	<span <?php echo $this->get_render_attribute_string( $item_label ); ?>>
	        		<?php echo wp_kses_post( $item['label'] ); ?>
	        	</span>
              </div>
            </div>
            <!-- counter end -->

          </div>
		  <?php endforeach; ?>
		</div>
		<?php endif; ?>

        <div class="tst-spacer tst-spacer-only-bottom-space"></div>

		</div>
		<!-- container end -->

		<?php
	}

	/**
	 * Render widget output in the editor.
	 *
	 * Written as a Backbone JavaScript template and used to generate the live preview.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function content_template() {
		?>

		<!-- container -->
		<div class="container">
		<# if ( settings.items ) { #>
		<div class="row">
		  <# _.each( settings.items, function( item, index ) {

		    var item_value = view.getRepeaterSettingKey( 'value', 'items', index );
		    view.addInlineEditingAttributes( item_value, 'none' );

		    var item_after = view.getRepeaterSettingKey( 'after', 'items', index );
		    view.addInlineEditingAttributes( item_after, 'none' );

		    var item_label = view.getRepeaterSettingKey( 'label', 'items', index );
		    view.addInlineEditingAttributes( item_label, 'basic' );

		  #>
          <div class="col-sm-6 col-lg-3">

            <!-- counter -->
            <div class="tst-count tst-mb-70">
              <div class="h3 tst-mb-15">
              	<span class="tst-number" data-count="{{{ item.value }}}">
              		<span {{{ view.getRenderAttributeString( item_value ) }}}>
		        		{{{ item.value }}}
		        	</span>
              	</span>
              	<span class="tst-color">
	          		<span {{{ view.getRenderAttributeString( item_after ) }}}>
		        		{{{ item.after }}}
		        	</span>
              	</span>
              </div>
              <div class="tst-label">
              	<span {{{ view.getRenderAttributeString( item_label ) }}}>
	        		{{{ item.label }}}
	        	</span>
              </div>
            </div>
            <!-- counter end -->

          </div>
          <# }); #>
        </div>
        <# } #>

		</div>
		<!-- container end -->

		<?php
	}
}

Plugin::instance()->widgets_manager->register( new Tastyc_Numbers_Widget() );
