<?php
namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

/**
 * Tastyc Section Divider Widget.
 *
 * @since 1.0
 */
class Tastyc_Section_Divider_Widget extends Widget_Base {

	public function get_name() {
		return 'tastyc-section-divider';
	}

	public function get_title() {
		return esc_html__( 'Section Divider', 'tastyc-plugin' );
	}

	public function get_icon() {
		return 'eicon-parallax';
	}

	public function get_categories() {
		return [ 'tastyc-category' ];
	}

	/**
	 * Register widget controls.
	 *
	 * @since 1.0
	 */
	protected function register_controls() {

		$this->start_controls_section(
			'content_tab',
			[
				'label' => esc_html__( 'Content', 'tastyc-plugin' ),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'bottom',
			[
				'label' => esc_html__( 'Only Bottom', 'tastyc-plugin' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => __( 'Yes', 'tastyc-plugin' ),
				'label_off' => __( 'No', 'tastyc-plugin' ),
				'return_value' => 'yes',
				'default' => 'no',
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'content_styling',
			[
				'label' => esc_html__( 'Content Styles', 'tastyc-plugin' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'line_color',
			[
				'label' => esc_html__( 'Line Color', 'tastyc-plugin' ),
				'type' => Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => [
					'{{WRAPPER}} .tst-spacer' => 'border-bottom-color: {{VALUE}};',
				],
			]
		);

		$this->end_controls_section();

	}


	/**
	 * Render widget output on the frontend.
	 *
	 * @since 1.0
	 */
	protected function render() {
		$settings = $this->get_settings_for_display();

		?>

		<div class="tst-spacer <?php if ( $settings['bottom'] == 'yes' ) : ?> tst-spacer-only-bottom-space<?php endif; ?>"></div>

		<?php
	}

	/**
	 * Render widget output in the editor.
	 *
	 * Written as a Backbone JavaScript template and used to generate the live preview.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function content_template() {
		?>

		<div class="tst-spacer <# if ( settings.bottom == 'yes' ) { #> tst-spacer-only-bottom-space<# } #>"></div>

		<?php
	}
}

Plugin::instance()->widgets_manager->register( new Tastyc_Section_Divider_Widget() );
