<?php
namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

/**
 * Tastyc Testimonials Widget.
 *
 * @since 1.0
 */
class Tastyc_Testimonials_Widget extends Widget_Base {

	public function get_name() {
		return 'tastyc-testimonials';
	}

	public function get_title() {
		return esc_html__( 'Testimonials', 'tastyc-plugin' );
	}

	public function get_icon() {
		return 'eicon-parallax';
	}

	public function get_categories() {
		return [ 'tastyc-category' ];
	}

	/**
	 * Register widget controls.
	 *
	 * @since 1.0
	 */
	protected function register_controls() {

		$this->start_controls_section(
			'title_tab',
			[
				'label' => esc_html__( 'Title', 'tastyc-plugin' ),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'subtitle',
			[
				'label'       => esc_html__( 'Subtitle', 'tastyc-plugin' ),
				'type'        => Controls_Manager::TEXTAREA,
				'placeholder' => esc_html__( 'Enter subtitle', 'tastyc-plugin' ),
				'default'     => esc_html__( 'Subtitle', 'tastyc-plugin' ),
			]
		);

		$this->add_control(
			'title',
			[
				'label'       => esc_html__( 'Title', 'tastyc-plugin' ),
				'type'        => Controls_Manager::TEXTAREA,
				'placeholder' => esc_html__( 'Enter title', 'tastyc-plugin' ),
				'default'     => esc_html__( 'Title', 'tastyc-plugin' ),
			]
		);

		$this->add_control(
			'title_tag',
			[
				'label'       => esc_html__( 'Title Tag', 'tastyc-plugin' ),
				'type'        => Controls_Manager::SELECT,
				'default' => 'h3',
				'options' => [
					'h1'  => __( 'H1', 'tastyc-plugin' ),
					'h2' => __( 'H2', 'tastyc-plugin' ),
					'h3' => __( 'H3', 'tastyc-plugin' ),
					'h4' => __( 'H4', 'tastyc-plugin' ),
					'div' => __( 'DIV', 'tastyc-plugin' ),
				],
			]
		);

		$this->add_control(
			'description',
			[
				'label'       => esc_html__( 'Description', 'tastyc-plugin' ),
				'type'        => Controls_Manager::TEXTAREA,
				'placeholder' => esc_html__( 'Enter description', 'tastyc-plugin' ),
				'default'     => esc_html__( 'Description', 'tastyc-plugin' ),
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'items_tab',
			[
				'label' => esc_html__( 'Items', 'tastyc-plugin' ),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
		);

		$repeater = new \Elementor\Repeater();

		$repeater->add_control(
			'image', [
				'label' => esc_html__( 'Image', 'tastyc-plugin' ),
				'type' => Controls_Manager::MEDIA,
				'default' => [
					'url' => \Elementor\Utils::get_placeholder_image_src(),
				],
			]
		);

		$repeater->add_control(
			'title', [
				'label'       => esc_html__( 'Title', 'tastyc-plugin' ),
				'type'        => Controls_Manager::TEXTAREA,
				'placeholder' => esc_html__( 'Enter title', 'tastyc-plugin' ),
				'default'	=> esc_html__( 'Title', 'tastyc-plugin' ),
			]
		);

		$repeater->add_control(
			'desc', [
				'label'       => esc_html__( 'Description', 'tastyc-plugin' ),
				'type'        => Controls_Manager::WYSIWYG,
				'placeholder' => esc_html__( 'Enter description', 'tastyc-plugin' ),
				'default'	=> esc_html__( 'Enter description', 'tastyc-plugin' ),
			]
		);

		$repeater->add_control(
			'name', [
				'label'       => esc_html__( 'Name', 'tastyc-plugin' ),
				'label_block' => true,
				'type'        => Controls_Manager::TEXT,
				'placeholder' => esc_html__( 'Enter name', 'tastyc-plugin' ),
				'default'	=> esc_html__( 'Name', 'tastyc-plugin' ),
			]
		);

		$repeater->add_control(
			'date', [
				'label'       => esc_html__( 'Date', 'tastyc-plugin' ),
				'label_block' => true,
				'type'        => Controls_Manager::TEXT,
				'placeholder' => esc_html__( 'Enter date', 'tastyc-plugin' ),
				'default'	=> esc_html__( 'Date', 'tastyc-plugin' ),
			]
		);

		$this->add_control(
			'items',
			[
				'label' => esc_html__( 'Testimonials Items', 'tastyc-plugin' ),
				'type' => Controls_Manager::REPEATER,
				'prevent_empty' => false,
				'fields' => $repeater->get_controls(),
				'title_field' => '{{{ name }}}',
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'buttons_tab',
			[
				'label' => esc_html__( 'Button', 'tastyc-plugin' ),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'button',
			[
				'label' => esc_html__( 'Button (Text)', 'tastyc-plugin' ),
				'label_block' => true,
				'type' => Controls_Manager::TEXT,
				'placeholder' => esc_html__( 'Button Text', 'tastyc-plugin' ),
				'default' => esc_html__( 'Button', 'tastyc-plugin' ),
			]
		);

		$this->add_control(
			'link',
			[
				'label' => esc_html__( 'Button (URL)', 'tastyc-plugin' ),
				'label_block' => true,
				'type' => Controls_Manager::URL,
				'show_external' => true,
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'title_styling',
			[
				'label'     => esc_html__( 'Title', 'tastyc-plugin' ),
				'tab'       => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'subtitle_color',
			[
				'label'     => esc_html__( 'Subtitle Color', 'tastyc-plugin' ),
				'type'      => Controls_Manager::COLOR,
				'default'	=> '',
				'selectors' => [
					'{{WRAPPER}} .row .tst-suptitle' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'     => 'subtitle_typography',
				'label'     => esc_html__( 'Subtitle Typography', 'tastyc-plugin' ),
				'selector' => '{{WRAPPER}} .row .tst-suptitle',
			]
		);

		$this->add_control(
			'title_color',
			[
				'label'     => esc_html__( 'Title Color', 'tastyc-plugin' ),
				'type'      => Controls_Manager::COLOR,
				'default'	=> '',
				'selectors' => [
					'{{WRAPPER}} .row .tst-title--h' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'     => 'title_typography',
				'label'     => esc_html__( 'Title Typography', 'tastyc-plugin' ),
				'selector' => '{{WRAPPER}} .row .tst-title--h',
			]
		);

		$this->add_control(
			'desc_color',
			[
				'label'     => esc_html__( 'Description Color', 'tastyc-plugin' ),
				'type'      => Controls_Manager::COLOR,
				'default'	=> '',
				'selectors' => [
					'{{WRAPPER}} .row .tst-text' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'     => 'desc_typography',
				'label'     => esc_html__( 'Description Typography', 'tastyc-plugin' ),
				'selector' => '{{WRAPPER}} .row .tst-text',
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'items_styling',
			[
				'label'     => esc_html__( 'Items', 'tastyc-plugin' ),
				'tab'       => Controls_Manager::TAB_STYLE,
			]
		);

    $this->add_control(
			'item_color',
			[
				'label'     => esc_html__( 'Item Color', 'tastyc-plugin' ),
				'type'      => Controls_Manager::COLOR,
				'default'	=> '',
				'selectors' => [
					'{{WRAPPER}} .tst-testimonial-card' => 'background-color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'item_q_color',
			[
				'label'     => esc_html__( 'Quote Color', 'tastyc-plugin' ),
				'type'      => Controls_Manager::COLOR,
				'default'	=> '',
				'selectors' => [
					'{{WRAPPER}} .tst-testimonial-card .tst-quote' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'item_title_color',
			[
				'label'     => esc_html__( 'Title Color', 'tastyc-plugin' ),
				'type'      => Controls_Manager::COLOR,
				'default'	=> '',
				'selectors' => [
					'{{WRAPPER}} .tst-testimonial-card h5' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'     => 'item_title_typography',
				'label'     => esc_html__( 'Title Typography', 'tastyc-plugin' ),
				'selector' => '{{WRAPPER}} .tst-testimonial-card h5',
			]
		);

		$this->add_control(
			'item_desc_color',
			[
				'label'     => esc_html__( 'Description Color', 'tastyc-plugin' ),
				'type'      => Controls_Manager::COLOR,
				'default'	=> '',
				'selectors' => [
					'{{WRAPPER}} .tst-testimonial-card .tst-text' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'     => 'item_desc_typography',
				'label'     => esc_html__( 'Description Typography', 'tastyc-plugin' ),
				'selector' => '{{WRAPPER}} .tst-testimonial-card .tst-text',
			]
		);

		$this->add_control(
			'item_name_color',
			[
				'label'     => esc_html__( 'Name Color', 'tastyc-plugin' ),
				'type'      => Controls_Manager::COLOR,
				'default'	=> '',
				'selectors' => [
					'{{WRAPPER}} .tst-testimonial-card h6' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'     => 'item_name_typography',
				'label'     => esc_html__( 'Name Typography', 'tastyc-plugin' ),
				'selector' => '{{WRAPPER}} .tst-testimonial-card h6',
			]
		);

		$this->add_control(
			'item_date_color',
			[
				'label'     => esc_html__( 'Date Color', 'tastyc-plugin' ),
				'type'      => Controls_Manager::COLOR,
				'default'	=> '',
				'selectors' => [
					'{{WRAPPER}} .tst-testimonial-card .tst-date' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'     => 'item_date_typography',
				'label'     => esc_html__( 'Date Typography', 'tastyc-plugin' ),
				'selector' => '{{WRAPPER}} .tst-testimonial-card .tst-date',
			]
		);

		$this->end_controls_section();
	}


	/**
	 * Render widget output on the frontend.
	 *
	 * @since 1.0
	 */
	protected function render() {
		$settings = $this->get_settings_for_display();

		$this->add_inline_editing_attributes( 'title', 'basic' );
		$this->add_inline_editing_attributes( 'subtitle', 'basic' );
		$this->add_inline_editing_attributes( 'description', 'basic' );
		$this->add_inline_editing_attributes( 'button', 'none' );

		?>

		<!-- container -->
		<div class="container">

		<div class="row">
		  <?php if ( $settings['title'] || $settings['subtitle'] || $settings['description'] ) : ?>
          <div class="col-lg-12">

            <!-- title -->
            <div class="text-center">
              <?php if ( $settings['subtitle'] ) : ?>
              <div class="tst-suptitle tst-suptitle-center tst-mb-15">
              	<span <?php echo $this->get_render_attribute_string( 'subtitle' ); ?>>
		          	<?php echo wp_kses_post( $settings['subtitle'] ); ?>
		        </span>
              </div>
              <?php endif; ?>
              <?php if ( $settings['title'] ) : ?>
              <<?php echo esc_attr( $settings['title_tag'] ); ?> class="tst-title--h tst-mb-30">
              	<span <?php echo $this->get_render_attribute_string( 'title' ); ?>>
		          	<?php echo wp_kses_post( $settings['title'] ); ?>
		        </span>
              </<?php echo esc_attr( $settings['title_tag'] ); ?>>
              <?php endif; ?>
              <?php if ( $settings['description'] ) : ?>
              <p class="tst-text">
              	<span <?php echo $this->get_render_attribute_string( 'description' ); ?>>
		          	<?php echo wp_kses_post( $settings['description'] ); ?>
		        </span>
              </p>
              <?php endif; ?>
            </div>
            <!-- title end -->

          </div>
      	  <?php endif; ?>

          <?php if ( $settings['items'] ) : ?>
          <div class="col-lg-12">

            <!-- testimonials slider -->
            <div class="swiper-container tst-testimonials-slider tst-cursor-scroll">
              <div class="swiper-wrapper">
                <?php foreach ( $settings['items'] as $index => $item ) :
			    $item_title = $this->get_repeater_setting_key( 'title', 'items', $index );
			    $this->add_inline_editing_attributes( $item_title, 'basic' );

			    $item_desc = $this->get_repeater_setting_key( 'desc', 'items', $index );
			    $this->add_inline_editing_attributes( $item_desc, 'advanced' );

			    $item_name = $this->get_repeater_setting_key( 'name', 'items', $index );
			    $this->add_inline_editing_attributes( $item_name, 'basic' );

			    $item_date = $this->get_repeater_setting_key( 'date', 'items', $index );
			    $this->add_inline_editing_attributes( $item_date, 'basic' );
			    ?>
                <div class="swiper-slide">

                  <!-- testimonials -->
                  <div class="tst-testimonial-card">
                    <div class="tst-quote"><?php echo esc_html__('"', 'tastyc-plugin' ); ?></div>
                    <?php if ( $item['title'] ) : ?>
                    <h5 class="tst-title--h tst-mb-30">
                    	<span <?php echo $this->get_render_attribute_string( $item_title ); ?>>
							<?php echo wp_kses_post( $item['title'] ); ?>
						</span>
                    </h5>
                    <?php endif; ?>
                    <?php if ( $item['desc'] ) : ?>
                    <div class="tst-text">
                    	<div <?php echo $this->get_render_attribute_string( $item_desc ); ?>>
							<?php echo wp_kses_post( $item['desc'] ); ?>
						</div>
                    </div>
                    <?php endif; ?>
                    <div class="tst-spacer-sm"></div>
                    <div class="tst-testimonial-bottom">
                      <div class="tst-visitor">
                      	<?php if ( $item['image'] ) : $image = wp_get_attachment_image_url( $item['image']['id'], 'tastyc_140x140' ); ?>
                        <img src="<?php echo esc_url( $image ); ?>" alt="<?php echo esc_attr( $item['name'] ); ?>">
                        <?php endif; ?>
                        <?php if ( $item['name'] ) : ?>
                        <h6>
                        	<span <?php echo $this->get_render_attribute_string( $item_name ); ?>>
								<?php echo wp_kses_post( $item['name'] ); ?>
							</span>
                        </h6>
                        <?php endif; ?>
                      </div>
                      <?php if ( $item['date'] ) : ?>
                      <div class="tst-date">
                      	 <span <?php echo $this->get_render_attribute_string( $item_date ); ?>>
							<?php echo wp_kses_post( $item['date'] ); ?>
						 </span>
                      </div>
                      <?php endif; ?>
                    </div>
                  </div>
                  <!-- testimonials end -->

                </div>
                <?php endforeach; ?>
              </div>
            </div>
            <!-- testimonials slider end -->

          </div>

          <div class="col-lg-12">

            <!-- slider navigation -->
            <div class="tst-slider-navigation">
              <?php if ( $settings['button'] ) : ?>
              <a<?php if ( $settings['link'] ) : ?><?php if ( $settings['link']['is_external'] ) : ?> target="_blank"<?php endif; ?><?php if ( $settings['link']['nofollow'] ) : ?> rel="nofollow"<?php endif; ?> href="<?php echo esc_url( $settings['link']['url'] ); ?>"<?php endif; ?> class="tst-btn tst-anima-link">
              	<span <?php echo $this->get_render_attribute_string( 'button' ); ?>>
		          	<?php echo wp_kses_post( $settings['button'] ); ?>
		        </span>
              </a>
          	  <?php endif; ?>
              <div class="tst-slider-pagination tst-testi-pagination"></div>
              <div class="tst-nav tst-right">
                <div class="tst-label"><?php echo esc_html__( 'Slider navigation', 'tastyc-plugin' ); ?></div>
                <div class="tst-slider-btn tst-testi-prev"><i class="fas fa-arrow-left"></i></div>
                <div class="tst-slider-btn tst-testi-next"><i class="fas fa-arrow-right"></i></div>
              </div>
            </div>
            <!-- slider navigation end -->

          </div>
          <?php endif; ?>
        </div>

        <div class="tst-spacer"></div>

		</div>
		<!-- container end -->

		<?php
	}

	/**
	 * Render widget output in the editor.
	 *
	 * Written as a Backbone JavaScript template and used to generate the live preview.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function content_template() {
		?>

		<#
		view.addInlineEditingAttributes( 'title', 'basic' );
		view.addInlineEditingAttributes( 'subtitle', 'basic' );
		view.addInlineEditingAttributes( 'description', 'basic' );
		view.addInlineEditingAttributes( 'button', 'none' );
		#>

		<!-- container -->
		<div class="container">

		<div class="row">
		  <# if ( settings.title || settings.subtitle || settings.description ) { #>
          <div class="col-lg-12">

            <!-- title -->
            <div class="text-center">
              <# if ( settings.subtitle ) { #>
              <div class="tst-suptitle tst-suptitle-center tst-mb-15">
              	<span {{{ view.getRenderAttributeString( 'subtitle' ) }}}>
		          	{{{ settings.subtitle }}}
		        </span>
              </div>
              <# } #>
              <# if ( settings.title ) { #>
              <{{{ settings.title_tag }}} class="tst-title--h tst-mb-30">
              	<span {{{ view.getRenderAttributeString( 'title' ) }}}>
		          	{{{ settings.title }}}
		        </span>
              </{{{ settings.title_tag }}}>
              <# } #>
              <# if ( settings.description ) { #>
              <p class="tst-text">
              	<span {{{ view.getRenderAttributeString( 'description' ) }}}>
		          	{{{ settings.description }}}
		        </span>
              </p>
              <# } #>
            </div>
            <!-- title end -->

          </div>
      	  <# } #>

          <# if ( settings.items ) { #>
          <div class="col-lg-12">

            <!-- testimonials slider -->
            <div class="swiper-container tst-testimonials-slider tst-cursor-scroll">
              <div class="swiper-wrapper">
                <# _.each( settings.items, function( item, index ) {

			    var item_title = view.getRepeaterSettingKey( 'title', 'items', index );
			    view.addInlineEditingAttributes( item_title, 'basic' );

			    var item_desc = view.getRepeaterSettingKey( 'desc', 'items', index );
			    view.addInlineEditingAttributes( item_desc, 'advanced' );

			    var item_name = view.getRepeaterSettingKey( 'name', 'items', index );
			    view.addInlineEditingAttributes( item_name, 'basic' );

			    var item_date = view.getRepeaterSettingKey( 'date', 'items', index );
			    view.addInlineEditingAttributes( item_date, 'basic' );

			    #>
                <div class="swiper-slide">

                  <!-- testimonials -->
                  <div class="tst-testimonial-card">
                    <div class="tst-quote">"</div>
                    <# if ( item.title ) { #>
                    <h5 class="tst-title--h tst-mb-30">
                    	<span {{{ view.getRenderAttributeString( item_title ) }}}>
				          	{{{ item.title }}}
				        </span>
                    </h5>
                    <# } #>
                    <# if ( item.desc ) { #>
                    <div class="tst-text">
                    	<div {{{ view.getRenderAttributeString( item_desc ) }}}>
				          	{{{ item.desc }}}
				        </div>
                    </div>
                    <# } #>
                    <div class="tst-spacer-sm"></div>
                    <div class="tst-testimonial-bottom">
                      <div class="tst-visitor">
                      	<# if ( item.image ) { #>
                        <img src="{{{ item.image.url }}}" alt="{{{ item.name }}}">
                        <# } #>
                        <# if ( item.name ) { #>
                        <h6>
                        	<span {{{ view.getRenderAttributeString( item_name ) }}}>
					          	{{{ item.name }}}
					        </span>
                        </h6>
                        <# } #>
                      </div>
                      <# if ( item.date ) { #>
                      <div class="tst-date">
                      	<span {{{ view.getRenderAttributeString( item_date ) }}}>
				          	{{{ item.date }}}
				        </span>
                      </div>
                      <# } #>
                    </div>
                  </div>
                  <!-- testimonials end -->

                </div>
                <# }); #>
              </div>
            </div>
            <!-- testimonials slider end -->

          </div>

          <div class="col-lg-12">

            <!-- slider navigation -->
            <div class="tst-slider-navigation">
              <# if ( settings.button ) { #>
              <a<# if ( settings.link ) { #><# if ( settings.link.is_external ) { #> target="_blank"<# } #><# if ( settings.link.nofollow ) { #> rel="nofollow"<# } #> href="{{{ settings.link.url }}}"<# } #> class="tst-btn tst-anima-link">
              	<span {{{ view.getRenderAttributeString( 'button' ) }}}>
		          	{{{ settings.button }}}
		        </span>
              </a>
          	  <# } #>
              <div class="tst-slider-pagination tst-testi-pagination"></div>
              <div class="tst-nav tst-right">
                <div class="tst-label">Slider navigation</div>
                <div class="tst-slider-btn tst-testi-prev"><i class="fas fa-arrow-left"></i></div>
                <div class="tst-slider-btn tst-testi-next"><i class="fas fa-arrow-right"></i></div>
              </div>
            </div>
            <!-- slider navigation end -->

          </div>
          <# } #>
        </div>

        <div class="tst-spacer"></div>

		</div>
		<!-- container end -->

		<?php
	}
}

Plugin::instance()->widgets_manager->register( new Tastyc_Testimonials_Widget() );
