<?php

/**
 * Register Custom Post Type: Theme Templates
 */

function tastyc_register_hf_templates() {
	$labels = array(
		'name'                  => _x( 'Theme Templates', 'Post Type General Name', 'tastyc-plugin' ),
		'singular_name'         => _x( 'Template', 'Post Type Singular Name', 'tastyc-plugin' ),
		'add_new_item'          => __( 'Add New Template', 'tastyc-plugin' ),
		'add_new'               => __( 'Add New', 'tastyc-plugin' ),
        'new_item'              => __( 'Add New Template', 'tastyc-plugin' ),
        'all_items'             => __( 'All Templates', 'tastyc-plugin' ),
		'edit_item'             => __( 'Edit Template', 'tastyc-plugin' ),
		'view_item'             => __( 'View Template', 'tastyc-plugin' ),
		'search_items'          => __( 'Search Template', 'tastyc-plugin' ),
		'not_found'             => __( 'No Templates Found', 'tastyc-plugin' ),
		'not_found_in_trash'    => __( 'No Templates Found in Trash', 'tastyc-plugin' ),
	);
	$args = array(
		'label'                 => __( 'Templates', 'tastyc-plugin' ),
		'description'           => __( 'Add a Template', 'tastyc-plugin' ),
		'labels'                => $labels,
		'supports' 				=> array( 'title', 'editor', 'thumbnail', 'author', 'elementor' ),
		'hierarchical'          => false,
		'show_in_nav_menus'     => false,
		'public'                => true,
		'show_ui'               => true,
		'exclude_from_search'   => true,
		'menu_position'         => 81,
		'menu_icon'             => 'dashicons-editor-insertmore',
		'can_export'            => true,
        'capability_type'       => 'post',
		'rewrite' 				=> array( 'slug' => 'hf_templates' ),
	);
	register_post_type( 'hf_templates', $args );
}
add_action( 'init', 'tastyc_register_hf_templates');

/**
 * Register Custom Post Type: Gallery
 */

function tastyc_register_gallery() {
	register_post_type( 'gallery', array(
			'label' => esc_html__( 'Gallery', 'tastyc-plugin' ),
	        'description' => esc_html__( 'Gallery', 'tastyc-plugin' ),
	        'supports' => array( 'title','editor','revisions','thumbnail','page-attributes' ),
	        'taxonomies' => array( 'gallery_categories' ),
	        'hierarchical' => false,
	        'show_in_rest' => true,
	        'public' => true,
	        'show_ui' => true,
	        'show_in_menu' => true,
	        'show_in_nav_menus' => true,
	        'show_in_admin_bar' => true,
	        'menu_position' => 20,
	        'menu_icon' => 'dashicons-images-alt2',
	        'can_export' => true,
	        'has_archive' => false,
	        'exclude_from_search' => true,
	        'publicly_queryable' => true,
	        'capability_type' => 'post',
	        'rewrite' => array( 'slug' => 'gallery/item', 'with_front' => true  ),
			'labels' => array(
				'name' => esc_html__( 'Gallery', 'tastyc-plugin' ),
		        'singular_name' => esc_html__( 'Gallery', 'tastyc-plugin' ),
		        'menu_name' => esc_html__( 'Gallery', 'tastyc-plugin' ),
		        'parent_item_colon' => esc_html__( 'Parent Image:', 'tastyc-plugin' ),
		        'all_items' => esc_html__( 'All Images', 'tastyc-plugin' ),
		        'view_item' => esc_html__( 'View Image', 'tastyc-plugin' ),
		        'add_new_item' => esc_html__( 'Add New Image', 'tastyc-plugin' ),
		        'add_new' => esc_html__( 'New Image', 'tastyc-plugin' ),
		        'edit_item' => esc_html__( 'Edit Image', 'tastyc-plugin' ),
		        'update_item' => esc_html__( 'Update Image', 'tastyc-plugin' ),
		        'search_items' => esc_html__( 'Search Images', 'tastyc-plugin' ),
		        'not_found' => esc_html__( 'No images found', 'tastyc-plugin' ),
		        'not_found_in_trash' => esc_html__( 'No images found in Trash', 'tastyc-plugin' ),
			),
		)
	);
}
add_action( 'init', 'tastyc_register_gallery' );

function tastyc_register_gallery_categories() {
	register_taxonomy( 'gallery_categories', array ( 0 => 'gallery' ),
		array(
			'label' => esc_html__( 'Gallery Categories', 'tastyc-plugin' ),
			'hierarchical' => true,
			'show_ui' => true,
			'show_in_rest' => true,
			'show_admin_column' => true,
			'query_var' => true,
			'has_archive' => true,
			'rewrite' => array( 'slug' => 'gallery/category' ),
			'labels' => array(
				'name'              => esc_html__( 'Gallery Categories', 'tastyc-plugin' ),
		        'singular_name'     => esc_html__( 'Gallery Categories', 'tastyc-plugin' ),
		        'search_items'      => esc_html__( 'Search Gallery Categories', 'tastyc-plugin' ),
		        'all_items'         => esc_html__( 'All Gallery Categories', 'tastyc-plugin' ),
		        'parent_item'       => esc_html__( 'Parent Gallery Category', 'tastyc-plugin' ),
		        'parent_item_colon' => esc_html__( 'Parent Gallery Category:', 'tastyc-plugin' ),
		        'edit_item'         => esc_html__( 'Edit Gallery Category', 'tastyc-plugin' ),
		        'update_item'       => esc_html__( 'Update Gallery Category', 'tastyc-plugin' ),
		        'add_new_item'      => esc_html__( 'Add New Gallery Category', 'tastyc-plugin' ),
		        'new_item_name'     => esc_html__( 'New Gallery Category Name', 'tastyc-plugin' ),
		        'menu_name'         => esc_html__( 'Gallery Categories', 'tastyc-plugin' ),
			)
		)
	);
}
add_action( 'init', 'tastyc_register_gallery_categories' );