<?php

/**
 * This file is part of the league/oauth2-client library
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 *
 * @copyright Copyright (c) Alex Bilbie <hello@alexbilbie.com>
 * @license http://opensource.org/licenses/MIT MIT
 * @link http://thephpleague.com/oauth2-client/ Documentation
 * @link https://packagist.org/packages/league/oauth2-client Packagist
 * @link https://github.com/thephpleague/oauth2-client GitHub
 */
namespace WPMailSMTP\Vendor\League\OAuth2\Client\OptionProvider;

use WPMailSMTP\Vendor\League\OAuth2\Client\Provider\AbstractProvider;
use WPMailSMTP\Vendor\League\OAuth2\Client\Tool\QueryBuilderTrait;
/**
 * Provide options for access token
 */
class PostAuthOptionProvider implements \WPMailSMTP\Vendor\League\OAuth2\Client\OptionProvider\OptionProviderInterface
{
    use QueryBuilderTrait;
    /**
     * @inheritdoc
     */
    public function getAccessTokenOptions($method, array $params)
    {
        $options = ['headers' => ['content-type' => 'application/x-www-form-urlencoded']];
        if ($method === \WPMailSMTP\Vendor\League\OAuth2\Client\Provider\AbstractProvider::METHOD_POST) {
            $options['body'] = $this->getAccessTokenBody($params);
        }
        return $options;
    }
    /**
     * Returns the request body for requesting an access token.
     *
     * @param  array $params
     * @return string
     */
    protected function getAccessTokenBody(array $params)
    {
        return $this->buildQueryString($params);
    }
}
