<?php
/**
 * The template for displaying the footer
 *
 * Contains the closing of the #content div and all content after.
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package tastyc
 */

?>
            </div>
            <div class="tst-content-frame--end tst-p-0-60"></div>
            
        </div>

      </div>

    </div>

    <?php 
		$footer_template = get_field( 'footer_template', 'option' ); 
		$footer_layout = get_field( 'footer_layout', 'option' ); 
	?>

    <!-- footer -->
    <footer class="<?php if ( $footer_layout == 0 ) : ?>tst-white tst-fade-down<?php endif; ?><?php if ( ! $footer_template ) : ?> tst-default<?php endif; ?><?php if ( $footer_layout == 1 ) : ?> white-footer<?php endif; ?>">
    <?php
        if ( $footer_template ) :
          $args = array( 'post_type' => 'hf_templates', 'p' => $footer_template );
          $loop = new WP_Query( $args );
          while ( $loop->have_posts() ) : $loop->the_post();
            the_content();
          endwhile; wp_reset_postdata();
        else :
      ?>
        <div class="container">
          <div class="tst-text align-center">
            <?php echo esc_html__( '© Tastyc 2021. All rights reserved.', 'tastyc' ); ?>
          </div>
        </div>
      <?php endif; ?>
    </footer>
    <!-- footer end -->
  
  </div>

  <?php

  $reservation_title = get_field( 'reservation_title', 'option' );
  $reservation_cf7_form = get_field( 'reservation_cf7_form', 'option' );
  $reservation_type = get_field( 'reservation_type', 'option' );
  $opentable_id = get_field( 'opentable_id', 'option' );
  $reservation_short = get_field( 'reservation_short', 'option' );

  ?>

  <!-- popup -->
  <div class="tst-popup-bg">
    <div class="tst-popup-frame">
      <div class="tst-popup-body">
        <div class="tst-close-popup"><i class="fas fa-times"></i></div>
        <!-- title -->
        <div class="text-center">
          <div class="tst-suptitle tst-suptitle-center"></div>
          <h4 class="tst-mb-60"><?php echo wp_kses_post( $reservation_title ); ?></h4>
        </div>
        <!-- title end-->
        
        <?php 
          if ( ! $reservation_type ) : 
            if ( $reservation_cf7_form ) : 
              the_field( 'reservation_cf7_form', 'option' ); 
            endif; 
          elseif ( $reservation_type == 1 ) :
            if ( $opentable_id ) :
              get_template_part( 'template-parts/reservation-opentable' );
            else :
              echo esc_html__( 'You haven\'t added OpenTable ID', 'tastyc' );
            endif;
          elseif ( $reservation_type == 2 ) :
            if ( $reservation_short ) : 
              echo do_shortcode( $reservation_short ); 
            endif;
          endif;
        ?>
      </div>
    </div>
  </div>
  <!-- popup end -->
	
<?php wp_footer(); ?>

</body>
</html>