<?php
/**
 * The header for our theme
 *
 * This is the template that displays all of the <head> section and everything up until <div id="content">
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package tastyc
 */

?>
<!doctype html>
<html <?php language_attributes(); ?>>
<head>
	<!-- Meta Data -->
	<meta charset="<?php bloginfo( 'charset' ); ?>">
	<meta http-equiv="X-UA-Compatible" content="IE=edge">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<link rel="profile" href="https://gmpg.org/xfn/11">

	<?php wp_head(); ?>
	
	<meta name="google-site-verification" content="1OIah7EJq4MNLXBJSfhSO08Cqnm92dshnMSXny32hjA" />
	
	<!-- Google tag (gtag.js) -->
<script async src="https://www.googletagmanager.com/gtag/js?id=G-3G8TK5GM4Q"></script>
<script>
  window.dataLayer = window.dataLayer || [];
  function gtag(){dataLayer.push(arguments);}
  gtag('js', new Date());

  gtag('config', 'G-3G8TK5GM4Q');
</script>
</head>

<?php

  $bg_type = get_field( 'bg_type', 'option' );
  $header_layout = get_field( 'header_layout', 'option' );
  $theme_layout = get_field( 'theme_layout', 'option' );
	$ui_type = get_field( 'ui_type', 'option' );
	$ui_skin = get_field( 'ui_skin', 'option' );
  $preloader_image = get_field( 'preloader_image', 'option' );
  $preloader_disable = get_field( 'preloader_disable', 'option' );
  $preloader_width = get_field( 'preloader_width', 'option' );
  $preloader_height = get_field( 'preloader_height', 'option' );
  if ( $bg_type == 'image' ) {
    $bg_image = get_field( 'bg_image', 'option' );
    $bg_image = wp_get_attachment_image_url( $bg_image, 'tastyc_1920xAuto' );
  }
  if ( $bg_type == 'color' ) {
    $bg_color = get_field( 'bg_color', 'option' );
  }

?>

<body <?php body_class(); ?> style="<?php if ( $bg_type == 'image' ) : ?>background-image: url(<?php echo esc_url( $bg_image ); ?>);<?php endif; ?><?php if ( $bg_type == 'color' ) : ?>background-color: <?php echo esc_attr( $bg_color ); ?>;<?php endif; ?>">
	<?php wp_body_open(); ?>

  <div class="tst-main-overlay<?php if ( $preloader_disable == 1 ) : ?> preloader-disabled<?php endif; ?>"<?php if ( $bg_type == 'color' ) : ?> style="background: <?php echo esc_attr( $bg_color ); ?>;"<?php endif; ?>>

    <!-- preloader -->
    <div class="tst-preloader-frame">
      <div class="tst-preloader" <?php if ( $preloader_image ) : ?>style="background-image: url(<?php echo esc_url( $preloader_image ); ?>);<?php if ( $preloader_width ) : ?> width: <?php echo esc_attr( $preloader_width ); ?>px;<?php endif; ?><?php if ( $preloader_height ) : ?> height: <?php echo esc_attr( $preloader_height ); ?>px;<?php endif; ?>"<?php endif; ?>>
        <?php if ( ! $preloader_image ) : ?><span></span>
        <span></span><?php endif; ?>
      </div>
    </div>
    <!-- preloader end -->

  </div>

  <div id="tst-app" class="tst-app<?php if ( $theme_layout == 1 ) : ?> full-layout<?php endif; ?><?php if ( $ui_type == 1 ) : ?> ui-minimal<?php endif; ?><?php if ( $ui_skin == 1 ) : ?> ui-dark<?php endif; ?><?php if ( $preloader_disable == 1 ) : ?> preloader-disabled<?php endif; ?>">

    <!-- top bar frame -->
    <div class="tst-menu-frame">
      <!-- top bar -->
      <div class="tst-dynamic-menu" id="tst-dynamic-menu">
        <div class="tst-menu<?php if ( $header_layout == 1 ) : ?> tst-menu-transparent<?php endif; ?>">

          <?php
            $header_template = get_field( 'header_template', 'option' );

            if ( $header_template != '' ) :
              $args = array( 'post_type' => 'hf_templates', 'p' => $header_template );
              $loop = new WP_Query( $args );
              while ( $loop->have_posts() ) : $loop->the_post();
                the_content();
              endwhile; wp_reset_postdata();
            else :
          ?>
            <!-- logo -->
            <a href="<?php echo esc_url( home_url() ); ?>">
              <span class="logotype__title"><?php echo esc_html( bloginfo('name') ); ?></span>
              <span class="logotype__sub"><?php echo esc_html( bloginfo('description') ); ?></span>
            </a>

            <!-- menu -->
            <div class="tst-menu-nav">
            <?php
            if ( has_nav_menu( 'primary' ) ) :
              wp_nav_menu( array(
                'theme_location' => 'primary',
                'container' => 'nav',
                'container_class' => 'top-menu-nav',
                'menu_class' => 'top-menu-nav-inner',
                'walker' => new Tastyc_Topmenu_Walker(),
              ) );
            endif; ?>
            </div>
            <!-- menu end -->

            <!-- top bar right -->
            <div class="tst-menu-right">

              <!-- Woocommerce cart -->
              <?php if ( class_exists( 'WooCommerce' ) ) : ?>
              <?php if ( true == get_theme_mod( 'cart_shop', true ) ) : ?>
              <div class="tst-minicart">
                <!-- minicart button -->
                <a href="#." class="tst-cart">
                  <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 128 128">
                    <path
                      d="M87.7,33.1l-0.8-10.8C86,10.4,76,1,64,1s-22.1,9.4-22.9,21.3l-0.8,10.8H28.8c-4.7,0-8.6,3.7-9,8.4l-5.4,75.9c0,0,0,0,0,0 c-0.2,2.5,0.7,5,2.4,6.8s4.1,2.9,6.6,2.9h81.3c2.5,0,4.9-1,6.6-2.9c1.7-1.8,2.6-4.3,2.4-6.8l-5.4-75.2c-0.4-5.1-4.6-9-9.7-9H87.7z M47.1,22.7C47.7,13.9,55.1,7,64,7s16.3,6.9,16.9,15.7l0.7,10.4H46.3L47.1,22.7z M102.3,42.6l5.4,75.2c0.1,0.8-0.2,1.6-0.8,2.3 c-0.6,0.6-1.4,1-2.2,1H23.4c-0.8,0-1.6-0.3-2.2-1s-0.9-1.4-0.8-2.3h0l5.4-75.9c0.1-1.6,1.4-2.8,3-2.8h11.1l-0.6,8 c-0.1,1.7,1.1,3.1,2.8,3.2c0.1,0,0.1,0,0.2,0c1.6,0,2.9-1.2,3-2.8l0.6-8.4h36.2l0.6,8.4c0.1,1.7,1.5,2.9,3.2,2.8 c1.7-0.1,2.9-1.5,2.8-3.2l-0.6-8h10.5C100.5,39.1,102.1,40.6,102.3,42.6z" />
                  </svg>
                  <div class="tst-cart-number">
                    <span class="cart-count"><?php echo sprintf (_n( '%d', '%d', WC()->cart->get_cart_contents_count(), 'tastyc' ), WC()->cart->get_cart_contents_count() ); ?></span>
                  </div>
                </a>
                <!-- minicart button end -->
                <!-- minicart -->
                <div class="tst-minicart-window">
                  <div class="cart-widget">
                    <?php woocommerce_mini_cart(); ?>
                  </div>
                </div>
                <!-- minicart end -->
              </div>
              <?php endif; ?>
              <?php endif; ?>

              <!-- menu button -->
              <div class="tst-menu-button-frame">
                <div class="tst-menu-btn">
                  <div class="tst-burger">
                    <span></span>
                  </div>
                </div>
              </div>
              <!-- menu button end -->
            </div>
            <!-- top bar right end  -->

          <?php endif; ?>

        </div>
      </div>
      <!-- top bar end -->
    </div>
    <!-- top bar frame -->

    <?php

    $started_layout = get_field( 'started_layout' );
    $hero_template = get_field( 'hero_template' );
    $intro_template = get_field( 'intro_template' );

    $shop_intro_template = false;
    $is_woo_shop = false;

    if ( class_exists( 'WooCommerce' ) ) :
      if ( is_woocommerce() ) :
        $is_woo_shop = true;
        $shop_intro_template = get_field( 'shop_intro_template', 'option' );
      endif;
    endif;

    ?>

    <div id="tst-dynamic-banner" class="tst-dynamic-banner">
      <?php if ( ! $started_layout && ! $shop_intro_template ) : ?>
      <div class="tst-dynamic-banner-empty"></div>
      <?php else : ?>

      <?php
        if ( $started_layout == 1 && $intro_template ) :
          $args = array( 'post_type' => 'hf_templates', 'p' => $intro_template );
          $loop = new WP_Query( $args );
          while ( $loop->have_posts() ) : $loop->the_post();
            the_content();
          endwhile; wp_reset_postdata();
        endif;
      ?>

      <?php
        if ( $started_layout == 2 && $hero_template ) :
          $args = array( 'post_type' => 'hf_templates', 'p' => $hero_template );
          $loop = new WP_Query( $args );
          while ( $loop->have_posts() ) : $loop->the_post();
            the_content();
          endwhile; wp_reset_postdata();
        endif;
      ?>

      <?php
       if ( $is_woo_shop && $shop_intro_template ) :
        $args = array( 'post_type' => 'hf_templates', 'p' => $shop_intro_template );
        $loop = new WP_Query( $args );
        while ( $loop->have_posts() ) : $loop->the_post();
          the_content();
        endwhile; wp_reset_postdata();
       endif;
      ?>

      <?php endif; ?>
    </div>

    <div id="tst-dynamic-content" class="tst-dynamic-content">

      <div class="tst-content-frame">
        <div class="tst-content-box">

          <div class="tst-content-frame--start tst-p-60-0">
            <!-- scroll hint -->
            <div class="container">
              <a href="#tst-dynamic-content" class="tst-scroll-hint-frame tst-anchor-scroll">
                <div class="tst-scroll-hint"></div>
              </a>
            </div>
            <!-- scroll hint end -->
          </div>
          <div class="tst-content-frame--container">
