<?php
/**
 * Skin
**/
function tastyc_skin() {
	$theme_bg_color = get_field( 'theme_bg_color', 'options' );
	$theme_color = get_field( 'theme_color', 'options' );

	$heading_color = get_field( 'heading_color', 'options' );
	$heading_font_family = get_field( 'heading_font_family', 'options' );

	$heading_font_size = get_field( 'heading_font_size', 'options' );
	$heading_font_weight = get_field( 'heading_font_weight', 'options' );
	$heading_letter_spacing = get_field( 'heading_letter_spacing', 'options' );
	$heading_font_transform = get_field( 'heading_font_transform', 'options' );

	$heading2_font_size = get_field( 'heading2_font_size', 'options' );
	$heading2_font_weight = get_field( 'heading2_font_weight', 'options' );
	$heading2_letter_spacing = get_field( 'heading2_letter_spacing', 'options' );
	$heading2_font_transform = get_field( 'heading2_font_transform', 'options' );

	$heading3_font_size = get_field( 'heading3_font_size', 'options' );
	$heading3_font_weight = get_field( 'heading3_font_weight', 'options' );
	$heading3_letter_spacing = get_field( 'heading3_letter_spacing', 'options' );
	$heading3_font_transform = get_field( 'heading3_font_transform', 'options' );

	$heading4_font_size = get_field( 'heading4_font_size', 'options' );
	$heading4_font_weight = get_field( 'heading4_font_weight', 'options' );
	$heading4_letter_spacing = get_field( 'heading4_letter_spacing', 'options' );
	$heading4_font_transform = get_field( 'heading4_font_transform', 'options' );

	$heading5_font_size = get_field( 'heading5_font_size', 'options' );
	$heading5_font_weight = get_field( 'heading5_font_weight', 'options' );
	$heading5_letter_spacing = get_field( 'heading5_letter_spacing', 'options' );
	$heading5_font_transform = get_field( 'heading5_font_transform', 'options' );

	$text_color = get_field( 'text_color', 'options' );
	$text_font_size = get_field( 'text_font_size', 'options' );
	$text_font_family = get_field( 'text_font_family', 'options' );
	$text_font_weight = get_field( 'text_font_weight', 'options' );
	$text_line_height = get_field( 'text_line_height', 'options' );
	$text_letter_spacing = get_field( 'text_letter_spacing', 'options' );

	$menu_font_color = get_field( 'menu_font_color', 'options' );

	$btn_color = get_field( 'btn_color', 'options' );
	$btn_txt_color = get_field( 'btn_txt_color', 'options' );
	$btn_font_size = get_field( 'btn_font_size', 'options' );
	$btn_font_family = get_field( 'btn_font_family', 'options' );
	$btn_font_weight = get_field( 'btn_font_weight', 'options' );
	$btn_letter_spacing = get_field( 'btn_letter_spacing', 'options' );
	$btn_font_transform = get_field( 'btn_font_transform', 'options' );
	$btn_border_radius = get_field( 'btn_border_radius', 'options' );
	$btn_border = get_field( 'btn_border', 'options' );
	$btn_height = get_field( 'btn_height', 'options' );
	$btn_transparent = get_field( 'btn_transparent', 'options' );

	$preloader_bg_color = get_field( 'preloader_bg_color', 'options' );
	$preloader_color = get_field( 'preloader_color', 'options' );

	$footer_bg_color = get_field( 'footer_bg_color', 'options' );

	$items_bg_color = get_field( 'items_bg_color', 'options' );
?>

<style>

	/* bg color */
	<?php if ( $theme_bg_color ) : ?>
	body,
	.tst-content-frame--start,
	.tst-content-frame--container,
	.tst-content-frame--end,
	.tst-content-frame .elementor-section,
	.tst-scroll-hint-frame,
	.swiper-menu .swiper-slide,
	.tst-minicart-window:after,
	.tst-minicart-window .woocommerce-mini-cart,
	.elementor-widget-tastyc-menu-simple .tst-menu-book-item .tst-menu-book-name h5 span,
	.elementor-widget-tastyc-menu-simple .tst-menu-book-item .tst-menu-book-descr .tst-menu-book-bottom .tst-menu-book-price .tst-price span,
	footer.white-footer,
	.page-template-default.elementor-page .tst-content-frame--container,
	.post-template-default.elementor-page .tst-content-frame--container,
	.woocommerce-cart .elementor-page .tst-content-frame--container,
	.tst-menu,
	.white-header .tst-menu-frame.tst-active .tst-menu,
	.tst-popup-bg .tst-popup-frame,
	.tst-minicart-window {
		background-color: <?php echo esc_attr( $theme_bg_color ); ?>;
	}
	@media (max-width: 992px) {
		.tst-menu-nav {
			background-color: <?php echo esc_attr( $theme_bg_color ); ?>;
		}
	}
	<?php endif; ?>

	/*headings*/
	<?php if ( $heading_color ) : ?>
	.h1, .h2, .h3, .h4, .h5, .h6, h1, h2, h3, h4, h5, h6 {
		color: <?php echo esc_attr( $heading_color ); ?>;
	}
	<?php endif; ?>
	<?php if ( ! empty( $heading_font_size ) ) : ?>
	@media (min-width: 993px) {
		.h1, h1 {
			font-size: <?php echo esc_attr( $heading_font_size ); ?>px;
		}
	}
	<?php endif; ?>
	<?php if ( ! empty( $heading_font_weight ) ) : ?>
	.h1, h1 {
		font-weight: <?php echo esc_attr( $heading_font_weight ); ?>;
	}
	<?php endif; ?>
	<?php if ( ! empty( $heading_letter_spacing ) ) : ?>
	@media (min-width: 993px) {
		.h1, h1 {
			letter-spacing: <?php echo esc_attr( $heading_letter_spacing ); ?>px;
		}
	}
	<?php endif; ?>
	<?php if ( ! empty( $heading_font_family ) ) : ?>
	h1.tst-main-title, h1.tst-title--h, .h1, h1,
	.tst-testimonial-card .tst-quote, .product-name a, span.logotype__title,
	.content-sidebar .wc-block-product-search__label {
		font-family: '<?php echo esc_attr( $heading_font_family['font_name'] ); ?>';
	}
	<?php endif; ?>
	<?php if ( ! empty( $heading_font_transform ) ) : ?>
	.h1, h1 {
		text-transform: <?php echo esc_attr( $heading_font_transform ); ?>;
	}
	<?php endif; ?>
	<?php if ( ! empty( $heading2_font_size ) ) : ?>
	@media (min-width: 993px) {
		.h2, h2 {
			font-size: <?php echo esc_attr( $heading2_font_size ); ?>px;
		}
	}
	<?php endif; ?>
	<?php if ( ! empty( $heading2_font_weight ) ) : ?>
	.h2, h2 {
		font-weight: <?php echo esc_attr( $heading2_font_weight ); ?>;
	}
	<?php endif; ?>
	<?php if ( ! empty( $heading2_letter_spacing ) ) : ?>
	@media (min-width: 993px) {
		.h2, h2 {
			letter-spacing: <?php echo esc_attr( $heading2_letter_spacing ); ?>px;
		}
	}
	<?php endif; ?>
	<?php if ( ! empty( $heading_font_family ) ) : ?>
	h2.tst-main-title, h2.tst-title--h, .h2, h2 {
		font-family: '<?php echo esc_attr( $heading_font_family['font_name'] ); ?>';
	}
	<?php endif; ?>
	<?php if ( ! empty( $heading2_font_transform ) && $heading2_font_transform != '' ) : ?>
	.h2, h2 {
		text-transform: <?php echo esc_attr( $heading2_font_transform ); ?>;
	}
	<?php endif; ?>
	<?php if ( ! empty( $heading3_font_size ) ) : ?>
	@media (min-width: 993px) {
		.h3, h3 {
			font-size: <?php echo esc_attr( $heading3_font_size ); ?>px;
		}
	}
	<?php endif; ?>
	<?php if ( ! empty( $heading3_font_weight ) ) : ?>
	.h3, h3 {
		font-weight: <?php echo esc_attr( $heading3_font_weight ); ?>;
	}
	<?php endif; ?>
	<?php if ( ! empty( $heading3_letter_spacing ) ) : ?>
	@media (min-width: 993px) {
		.h3, h3 {
			letter-spacing: <?php echo esc_attr( $heading3_letter_spacing ); ?>px;
		}
	}
	<?php endif; ?>
	<?php if ( ! empty( $heading_font_family ) ) : ?>
	h3.tst-main-title, h3.tst-title--h, .h3, h3 {
		font-family: '<?php echo esc_attr( $heading_font_family['font_name'] ); ?>';
	}
	<?php endif; ?>
	<?php if ( ! empty( $heading3_font_transform ) ) : ?>
	.h3, h3 {
		text-transform: <?php echo esc_attr( $heading3_font_transform ); ?>;
	}
	<?php endif; ?>
	<?php if ( ! empty( $heading4_font_size ) ) : ?>
	@media (min-width: 993px) {
		.h4, h4 {
			font-size: <?php echo esc_attr( $heading4_font_size ); ?>px;
		}
	}
	<?php endif; ?>
	<?php if ( ! empty( $heading4_font_weight ) ) : ?>
	.h4, h4 {
		font-weight: <?php echo esc_attr( $heading4_font_weight ); ?>;
	}
	<?php endif; ?>
	<?php if ( ! empty( $heading4_letter_spacing ) ) : ?>
	@media (min-width: 993px) {
		.h4, h4 {
			letter-spacing: <?php echo esc_attr( $heading4_letter_spacing ); ?>px;
		}
	}
	<?php endif; ?>
	<?php if ( ! empty( $heading_font_family ) ) : ?>
	h4.tst-main-title, h4.tst-title--h, .h4, h4 {
		font-family: '<?php echo esc_attr( $heading_font_family['font_name'] ); ?>';
	}
	<?php endif; ?>
	<?php if ( ! empty( $heading4_font_transform ) ) : ?>
	.h4, h4 {
		text-transform: <?php echo esc_attr( $heading4_font_transform ); ?>;
	}
	<?php endif; ?>
	<?php if ( ! empty( $heading5_font_size ) ) : ?>
	@media (min-width: 993px) {
		.h5, h5 {
			font-size: <?php echo esc_attr( $heading5_font_size ); ?>px;
		}
	}
	<?php endif; ?>
	<?php if ( ! empty( $heading5_font_weight ) ) : ?>
	.h5, h5 {
		font-weight: <?php echo esc_attr( $heading5_font_weight ); ?>;
	}
	<?php endif; ?>
	<?php if ( ! empty( $heading5_letter_spacing ) ) : ?>
	@media (min-width: 993px) {
		.h5, h5 {
			letter-spacing: <?php echo esc_attr( $heading5_letter_spacing ); ?>px;
		}
	}
	<?php endif; ?>
	<?php if ( ! empty( $heading_font_family ) ) : ?>
	h5.tst-main-title, h5.tst-title--h, .h5, h5 {
		font-family: '<?php echo esc_attr( $heading_font_family['font_name'] ); ?>';
	}
	<?php endif; ?>
	<?php if ( ! empty( $heading5_font_transform ) ) : ?>
	.h5, h5 {
		text-transform: <?php echo esc_attr( $heading5_font_transform ); ?>;
	}
	<?php endif; ?>

	/* paragraphs */
	<?php if ( $text_color ) : ?>
	body,
	.tst-text,
	.tst-text.tst-text-lg,
	.product-name a,
	.content-sidebar .widget,
	.woocommerce ul.products li.product,
	.woocommerce-page ul.products li.product,
	.title.comment-reply-title,
	.post-comments .title {
		color: <?php echo esc_attr( $text_color ); ?>;
	}
	<?php endif; ?>
	<?php if ( $text_font_family ) : ?>
	body,
	.h6,
	h6,
	.tst-text,
	.tst-label,
	.tst-icon-link,
	.tst-suptitle,
	.tst-btn,
	.tst-menu-nav ul li a,
	.tst-breadcrumbs li,
	.swiper-menu-nav .swiper-pagination-bullet,
	.tst-minicart-window .woocommerce-mini-cart .woocommerce-mini-cart-item a,
	.tst-minicart-window .woocommerce-mini-cart__total strong,
	.tst-minicart-window .woocommerce-mini-cart__buttons a,
	.tst-shop-list-header .woocommerce-result-count,
	.widget-area .widget_product_categories ul li,
	.widget-area .product_list_widget li a,
	.woocommerce-product-search button,
	.woocommerce button,
	table thead tr th,
	.cart_item td:before,
	.cart_totals table tbody tr.cart-subtotal td:before,
	.cart_totals table tbody tr.order-total td:before,
	.checkout-button,
	.wc-proceed-to-checkout a.checkout-button,
	.datepicker {
		font-family: '<?php echo esc_attr( $text_font_family['font_name'] ); ?>';
	}
	<?php endif; ?>
	<?php if ( $text_font_size ) : ?>
	body,
	.tst-text,
	.tst-text.tst-text-lg,
	.product-name a,
	.content-sidebar .widget,
	.woocommerce ul.products li.product,
	.woocommerce-page ul.products li.product,
	.title.comment-reply-title,
	.post-comments .title {
		font-size: <?php echo esc_attr( $text_font_size ); ?>px;
	}
	<?php endif; ?>
	<?php if ( ! empty( $text_font_weight ) ) : ?>
	body,
	.tst-text,
	.tst-text.tst-text-lg,
	.product-name a,
	.content-sidebar .widget,
	.woocommerce ul.products li.product,
	.woocommerce-page ul.products li.product,
	.title.comment-reply-title,
	.post-comments .title {
		font-weight: <?php echo esc_attr( $text_font_weight ); ?>;
	}
	<?php endif; ?>
	<?php if ( ! empty( $text_line_height ) && $text_line_height != '' ) : ?>
	body,
	.tst-text,
	.tst-text.tst-text-lg,
	.product-name a,
	.content-sidebar .widget,
	.woocommerce ul.products li.product,
	.woocommerce-page ul.products li.product,
	.title.comment-reply-title,
	.post-comments .title {
		line-height: <?php echo esc_attr( $text_line_height ); ?>;
	}
	<?php endif; ?>
	<?php if ( ! empty( $text_letter_spacing ) && $text_letter_spacing != '' ) : ?>
	body,
	.tst-text,
	.tst-text.tst-text-lg,
	.product-name a,
	.content-sidebar .widget,
	.woocommerce ul.products li.product,
	.woocommerce-page ul.products li.product,
	.title.comment-reply-title,
	.post-comments .title {
		letter-spacing: <?php echo esc_attr( $text_letter_spacing ); ?>px;
	}
	<?php endif; ?>

	/*menu items*/
	<?php if ( $menu_font_color ) : ?>
	.tst-menu-nav > ul > li > a {
		color: <?php echo esc_attr( $menu_font_color ); ?>;
	}
	<?php endif; ?>

	/* theme color */
	<?php if ( $theme_color ) : ?>
	.tst-suptitle:before,
	.tst-btn,
	.tst-menu-nav ul li.current-menu-item:after,
	.tst-menu-nav ul li ul,
	.tst-banner .tst-cover-frame .tst-lock.tst-active,
	.tst-call-to-action .tst-cover-frame .tst-lock.tst-active,
	.tst-about-cover .tst-play-button,
	.tst-blog-card .tst-cover-frame .tst-card-badge,
	.tst-breadcrumbs,
	.swiper-menu-nav .swiper-pagination-bullet-active,
	.tst-minicart-window .woocommerce-mini-cart__buttons a,
	.woocommerce-product-search button,
	.tst-slider-navigation .tst-nav .tst-slider-btn,
	.datepicker .datepicker--cell.-selected-,
	.datepicker .datepicker--cell.-selected-.-current-,
	.datepicker .datepicker--cell.-selected-:hover,
	.datepicker .datepicker--cell.-selected-.-current-:hover,
	.content-sidebar td#today,
	.single-post-text ul>li:before,
	.tst-comment-content ul>li:before,
	.sticky:before,
	.wp-block-button a.wp-block-button__link,
	.woocommerce #respond input#submit,
	.woocommerce a.button,
	.woocommerce button.button,
	.woocommerce input.button .woocommerce-mini-cart__buttons #respond input#submit,
	.woocommerce-mini-cart__buttons a.button,
	.woocommerce-mini-cart__buttons button.button,
	.woocommerce-mini-cart__buttons input.button,
	.woocommerce #respond input#submit:hover,
	.woocommerce a.button:hover,
	.woocommerce button.button:hover,
	.woocommerce input.button:hover .woocommerce-mini-cart__buttons #respond input#submit:hover,
	.woocommerce-mini-cart__buttons a.button:hover,
	.woocommerce-mini-cart__buttons button.button:hover,
	.woocommerce-mini-cart__buttons input.button:hover,
	.woocommerce span.onsale,
	.woocommerce ul.products li.product .button.add_to_cart_button,
	.woocommerce #respond input#submit.alt,
	.woocommerce a.button.alt,
	.woocommerce button.button.alt,
	.woocommerce input.button.alt,
	.tst-pagination a.current,
	.tst-pagination span.current,
	.tst-blog-pagination a.current,
	.tst-blog-pagination span.current,
	.page-links a.current,
	.page-links span.current,
	.post-password-form input[type="submit"],
	.woocommerce .widget_price_filter .price_slider_wrapper .ui-widget-content,
	.woocommerce .widget_price_filter .ui-slider .ui-slider-range,
	.woocommerce .widget_price_filter .ui-slider .ui-slider-handle,
	.tst-skills-box .progress .percentage,
	.tst-timeline .tst-timeline-item .tst-year:before,
	.tst-timeline:after,
	.woocommerce nav.woocommerce-pagination ul li a:focus,
	.woocommerce nav.woocommerce-pagination ul li a:hover,
	.woocommerce nav.woocommerce-pagination ul li span.current,
	.tst-menu-book-item .tst-menu-book-descr .tst-menu-book-bottom .added_to_cart {
		background-color: <?php echo esc_attr( $theme_color ); ?>;
	}
	.woocommerce button,
	.checkout-button,
	.wc-proceed-to-checkout a.checkout-button {
		background-color: <?php echo esc_attr( $theme_color ); ?> !important;
	}
	a.tst-color:hover,
	a:hover.tst-color:hover,
	.tst-icon-link:hover,
	.tst-color,
	.tst-testimonial-card .tst-quote,
	.post-text-bottom span.cat-links a,
	.post-text-bottom .tags-links a,
	.post-text-bottom .tags-links span,
	.content-sidebar .tagcloud a,
	.wp-block-tag-cloud .tag-cloud-link,
	.wp-block-button.is-style-outline a.wp-block-button__link,
	.error-page__num,
	.woocommerce .star-rating,
	.woocommerce p.stars a,
	.tst-pricing-box.marked:before,
	.tst-skills-box.list .name:before,
	.tst-menu-nav .top-menu-nav > ul > li:hover > a {
		color: <?php echo esc_attr( $theme_color ); ?>;
	}
	.tst-preloader-frame .tst-preloader span,
	.swiper-pagination-bullet.swiper-pagination-bullet-active,
	.tst-main-pagination .swiper-pagination-bullet,
	.tst-main-pagination .swiper-pagination-bullet.swiper-pagination-bullet-active,
	.post-text-bottom .tags-links a,
	.post-text-bottom .tags-links span,
	.content-sidebar .tagcloud a,
	.wp-block-tag-cloud .tag-cloud-link,
	.wp-block-pullquote blockquote,
	.wp-block-button.is-style-outline a.wp-block-button__link,
	.tst-timeline .tst-timeline-item .tst-year:after,
	.tst-menu-book-item .tst-menu-book-descr .tst-menu-book-bottom .added_to_cart:before {
		border-color: <?php echo esc_attr( $theme_color ); ?>;
	}
	.tst-preloader-frame .tst-preloader span {
		border-top: 6px solid transparent;
	}
	.mapboxgl-marker svg g {
		fill: <?php echo esc_attr( $theme_color ); ?>;
	}
	::-webkit-scrollbar-thumb {
		background: <?php echo esc_attr( $theme_color ); ?>;
	}
	<?php endif; ?>

	/* buttons */
	<?php if ( $btn_color ) : ?>
	.tst-btn,
	.tst-about-cover .tst-play-button,
	.tst-minicart-window .woocommerce-mini-cart__buttons a,
	.woocommerce-product-search button,
	.wp-block-button a.wp-block-button__link,
	.woocommerce #respond input#submit,
	.woocommerce a.button,
	.woocommerce button.button,
	.woocommerce input.button .woocommerce-mini-cart__buttons #respond input#submit,
	.woocommerce-mini-cart__buttons a.button,
	.woocommerce-mini-cart__buttons button.button,
	.woocommerce-mini-cart__buttons input.button,
	.woocommerce #respond input#submit:hover,
	.woocommerce a.button:hover,
	.woocommerce button.button:hover,
	.woocommerce input.button:hover .woocommerce-mini-cart__buttons #respond input#submit:hover,
	.woocommerce-mini-cart__buttons a.button:hover,
	.woocommerce-mini-cart__buttons button.button:hover,
	.woocommerce-mini-cart__buttons input.button:hover,
	.woocommerce ul.products li.product .button.add_to_cart_button,
	.woocommerce #respond input#submit.alt,
	.woocommerce a.button.alt,
	.woocommerce button.button.alt,
	.woocommerce input.button.alt,
	.post-password-form input[type="submit"],
	.filter.gallery-filter ul li.active {
		background-color: <?php echo esc_attr( $btn_color ); ?>;
	}
	.woocommerce button,
	.checkout-button,
	.wc-proceed-to-checkout a.checkout-button {
		background-color: <?php echo esc_attr( $btn_color ); ?> !important;
	}
	.tst-icon-link:hover,
	.wp-block-button.is-style-outline a.wp-block-button__link {
		color: <?php echo esc_attr( $btn_color ); ?>;
	}
	.wp-block-button.is-style-outline a.wp-block-button__link {
		border-color: <?php echo esc_attr( $btn_color ); ?>;
	}
	<?php endif; ?>
	<?php if ( $btn_txt_color ) : ?>
	.tst-btn,
	a.tst-btn,
	.tst-about-cover .tst-play-button,
	.tst-minicart-window .woocommerce-mini-cart__buttons a,
	.woocommerce-product-search button,
	.wp-block-button a.wp-block-button__link,
	.woocommerce #respond input#submit,
	.woocommerce a.button,
	.woocommerce button.button,
	.woocommerce input.button .woocommerce-mini-cart__buttons #respond input#submit,
	.woocommerce-mini-cart__buttons a.button,
	.woocommerce-mini-cart__buttons button.button,
	.woocommerce-mini-cart__buttons input.button,
	.woocommerce #respond input#submit:hover,
	.woocommerce a.button:hover,
	.woocommerce button.button:hover,
	.woocommerce input.button:hover .woocommerce-mini-cart__buttons #respond input#submit:hover,
	.woocommerce-mini-cart__buttons a.button:hover,
	.woocommerce-mini-cart__buttons button.button:hover,
	.woocommerce-mini-cart__buttons input.button:hover,
	.woocommerce ul.products li.product .button.add_to_cart_button,
	.woocommerce #respond input#submit.alt,
	.woocommerce a.button.alt,
	.woocommerce button.button.alt,
	.woocommerce input.button.alt,
	.post-password-form input[type="submit"] {
		color: <?php echo esc_attr( $btn_txt_color ); ?>;
	}
	.woocommerce button,
	.checkout-button,
	.wc-proceed-to-checkout a.checkout-button {
		color: <?php echo esc_attr( $btn_txt_color ); ?> !important;
	}
	<?php endif; ?>
	<?php if ( $btn_font_family ) : ?>
	.tst-btn,
	a.tst-btn,
	.tst-about-cover .tst-play-button,
	.tst-minicart-window .woocommerce-mini-cart__buttons a,
	.woocommerce-product-search button,
	.wp-block-button a.wp-block-button__link,
	.woocommerce #respond input#submit,
	.woocommerce a.button,
	.woocommerce button.button,
	.woocommerce input.button .woocommerce-mini-cart__buttons #respond input#submit,
	.woocommerce-mini-cart__buttons a.button,
	.woocommerce-mini-cart__buttons button.button,
	.woocommerce-mini-cart__buttons input.button,
	.woocommerce #respond input#submit:hover,
	.woocommerce a.button:hover,
	.woocommerce button.button:hover,
	.woocommerce input.button:hover .woocommerce-mini-cart__buttons #respond input#submit:hover,
	.woocommerce-mini-cart__buttons a.button:hover,
	.woocommerce-mini-cart__buttons button.button:hover,
	.woocommerce-mini-cart__buttons input.button:hover,
	.woocommerce ul.products li.product .button.add_to_cart_button,
	.woocommerce #respond input#submit.alt,
	.woocommerce a.button.alt,
	.woocommerce button.button.alt,
	.woocommerce input.button.alt,
	.post-password-form input[type="submit"],
	a.tst-label {
		font-family: '<?php echo esc_attr( $btn_font_family['font_name'] ); ?>';
	}
	<?php endif; ?>
	<?php if ( $btn_font_size ) : ?>
	.tst-btn,
	a.tst-btn,
	.tst-about-cover .tst-play-button,
	.tst-minicart-window .woocommerce-mini-cart__buttons a,
	.woocommerce-product-search button,
	.wp-block-button a.wp-block-button__link,
	.woocommerce #respond input#submit,
	.woocommerce a.button,
	.woocommerce button.button,
	.woocommerce input.button .woocommerce-mini-cart__buttons #respond input#submit,
	.woocommerce-mini-cart__buttons a.button,
	.woocommerce-mini-cart__buttons button.button,
	.woocommerce-mini-cart__buttons input.button,
	.woocommerce #respond input#submit:hover,
	.woocommerce a.button:hover,
	.woocommerce button.button:hover,
	.woocommerce input.button:hover .woocommerce-mini-cart__buttons #respond input#submit:hover,
	.woocommerce-mini-cart__buttons a.button:hover,
	.woocommerce-mini-cart__buttons button.button:hover,
	.woocommerce-mini-cart__buttons input.button:hover,
	.woocommerce ul.products li.product .button.add_to_cart_button,
	.woocommerce #respond input#submit.alt,
	.woocommerce a.button.alt,
	.woocommerce button.button.alt,
	.woocommerce input.button.alt,
	.post-password-form input[type="submit"],
	a.tst-label {
		font-size: <?php echo esc_attr( $btn_font_size ); ?>px;
	}
	<?php endif; ?>
	<?php if ( ! empty( $btn_font_weight ) ) : ?>
	.tst-btn,
	a.tst-btn,
	.tst-about-cover .tst-play-button,
	.tst-minicart-window .woocommerce-mini-cart__buttons a,
	.woocommerce-product-search button,
	.wp-block-button a.wp-block-button__link,
	.woocommerce #respond input#submit,
	.woocommerce a.button,
	.woocommerce button.button,
	.woocommerce input.button .woocommerce-mini-cart__buttons #respond input#submit,
	.woocommerce-mini-cart__buttons a.button,
	.woocommerce-mini-cart__buttons button.button,
	.woocommerce-mini-cart__buttons input.button,
	.woocommerce #respond input#submit:hover,
	.woocommerce a.button:hover,
	.woocommerce button.button:hover,
	.woocommerce input.button:hover .woocommerce-mini-cart__buttons #respond input#submit:hover,
	.woocommerce-mini-cart__buttons a.button:hover,
	.woocommerce-mini-cart__buttons button.button:hover,
	.woocommerce-mini-cart__buttons input.button:hover,
	.woocommerce ul.products li.product .button.add_to_cart_button,
	.woocommerce #respond input#submit.alt,
	.woocommerce a.button.alt,
	.woocommerce button.button.alt,
	.woocommerce input.button.alt,
	.post-password-form input[type="submit"],
	a.tst-label {
		font-weight: <?php echo esc_attr( $btn_font_weight ); ?>;
	}
	<?php endif; ?>
	<?php if ( ! empty( $btn_letter_spacing ) || $btn_letter_spacing == 0 ) : ?>
	.tst-btn,
	a.tst-btn,
	.tst-about-cover .tst-play-button,
	.tst-minicart-window .woocommerce-mini-cart__buttons a,
	.woocommerce-product-search button,
	.wp-block-button a.wp-block-button__link,
	.woocommerce #respond input#submit,
	.woocommerce a.button,
	.woocommerce button.button,
	.woocommerce input.button .woocommerce-mini-cart__buttons #respond input#submit,
	.woocommerce-mini-cart__buttons a.button,
	.woocommerce-mini-cart__buttons button.button,
	.woocommerce-mini-cart__buttons input.button,
	.woocommerce #respond input#submit:hover,
	.woocommerce a.button:hover,
	.woocommerce button.button:hover,
	.woocommerce input.button:hover .woocommerce-mini-cart__buttons #respond input#submit:hover,
	.woocommerce-mini-cart__buttons a.button:hover,
	.woocommerce-mini-cart__buttons button.button:hover,
	.woocommerce-mini-cart__buttons input.button:hover,
	.woocommerce ul.products li.product .button.add_to_cart_button,
	.woocommerce #respond input#submit.alt,
	.woocommerce a.button.alt,
	.woocommerce button.button.alt,
	.woocommerce input.button.alt,
	.post-password-form input[type="submit"],
	a.tst-label {
		letter-spacing: <?php echo esc_attr( $btn_letter_spacing ); ?>px;
	}
	<?php endif; ?>
	<?php if ( ! empty( $btn_font_transform ) && $btn_font_transform != 'unset' ) : ?>
	.tst-btn,
	a.tst-btn,
	.tst-about-cover .tst-play-button,
	.tst-minicart-window .woocommerce-mini-cart__buttons a,
	.woocommerce-product-search button,
	.wp-block-button a.wp-block-button__link,
	.woocommerce #respond input#submit,
	.woocommerce a.button,
	.woocommerce button.button,
	.woocommerce input.button .woocommerce-mini-cart__buttons #respond input#submit,
	.woocommerce-mini-cart__buttons a.button,
	.woocommerce-mini-cart__buttons button.button,
	.woocommerce-mini-cart__buttons input.button,
	.woocommerce #respond input#submit:hover,
	.woocommerce a.button:hover,
	.woocommerce button.button:hover,
	.woocommerce input.button:hover .woocommerce-mini-cart__buttons #respond input#submit:hover,
	.woocommerce-mini-cart__buttons a.button:hover,
	.woocommerce-mini-cart__buttons button.button:hover,
	.woocommerce-mini-cart__buttons input.button:hover,
	.woocommerce ul.products li.product .button.add_to_cart_button,
	.woocommerce #respond input#submit.alt,
	.woocommerce a.button.alt,
	.woocommerce button.button.alt,
	.woocommerce input.button.alt,
	.post-password-form input[type="submit"],
	a.tst-label {
		text-transform: <?php echo esc_attr( $btn_font_transform ); ?>;
	}
	<?php endif; ?>
	<?php if ( ! empty( $btn_border_radius ) || $btn_border_radius == 0 ) : ?>
	.tst-btn,
	a.tst-btn,
	.tst-about-cover .tst-play-button,
	.tst-minicart-window .woocommerce-mini-cart__buttons a,
	.woocommerce-product-search button,
	.wp-block-button a.wp-block-button__link,
	.woocommerce #respond input#submit,
	.woocommerce a.button,
	.woocommerce button.button,
	.woocommerce input.button .woocommerce-mini-cart__buttons #respond input#submit,
	.woocommerce-mini-cart__buttons a.button,
	.woocommerce-mini-cart__buttons button.button,
	.woocommerce-mini-cart__buttons input.button,
	.woocommerce #respond input#submit:hover,
	.woocommerce a.button:hover,
	.woocommerce button.button:hover,
	.woocommerce input.button:hover .woocommerce-mini-cart__buttons #respond input#submit:hover,
	.woocommerce-mini-cart__buttons a.button:hover,
	.woocommerce-mini-cart__buttons button.button:hover,
	.woocommerce-mini-cart__buttons input.button:hover,
	.woocommerce ul.products li.product .button.add_to_cart_button,
	.woocommerce #respond input#submit.alt,
	.woocommerce a.button.alt,
	.woocommerce button.button.alt,
	.woocommerce input.button.alt,
	.post-password-form input[type="submit"] {
		border-radius: <?php echo esc_attr( $btn_border_radius ); ?>px;
	}
	<?php endif; ?>
	<?php if ( ! empty( $btn_border ) && $btn_color != '' ) : ?>
	.tst-btn,
	a.tst-btn,
	.tst-about-cover .tst-play-button,
	.tst-minicart-window .woocommerce-mini-cart__buttons a,
	.woocommerce-product-search button,
	.wp-block-button a.wp-block-button__link,
	.woocommerce #respond input#submit,
	.woocommerce a.button,
	.woocommerce button.button,
	.woocommerce input.button .woocommerce-mini-cart__buttons #respond input#submit,
	.woocommerce-mini-cart__buttons a.button,
	.woocommerce-mini-cart__buttons button.button,
	.woocommerce-mini-cart__buttons input.button,
	.woocommerce #respond input#submit:hover,
	.woocommerce a.button:hover,
	.woocommerce button.button:hover,
	.woocommerce input.button:hover .woocommerce-mini-cart__buttons #respond input#submit:hover,
	.woocommerce-mini-cart__buttons a.button:hover,
	.woocommerce-mini-cart__buttons button.button:hover,
	.woocommerce-mini-cart__buttons input.button:hover,
	.woocommerce ul.products li.product .button.add_to_cart_button,
	.woocommerce #respond input#submit.alt,
	.woocommerce a.button.alt,
	.woocommerce button.button.alt,
	.woocommerce input.button.alt,
	.post-password-form input[type="submit"] {
		border: <?php echo esc_attr( $btn_border ); ?>px solid <?php echo esc_attr( $btn_color ); ?>;
		line-height: 58px;
	}
	.tst-menu-book-item.tst-mbi-3 .tst-btn.tst-cart-btn {
		line-height: 50px;
	}
	<?php endif; ?>
	<?php if ( $btn_transparent == 1 ) : ?>
	.tst-btn,
	a.tst-btn,
	.tst-about-cover .tst-play-button,
	.tst-minicart-window .woocommerce-mini-cart__buttons a,
	.woocommerce-product-search button,
	.wp-block-button a.wp-block-button__link,
	.woocommerce #respond input#submit,
	.woocommerce a.button,
	.woocommerce button.button,
	.woocommerce input.button .woocommerce-mini-cart__buttons #respond input#submit,
	.woocommerce-mini-cart__buttons a.button,
	.woocommerce-mini-cart__buttons button.button,
	.woocommerce-mini-cart__buttons input.button,
	.woocommerce #respond input#submit:hover,
	.woocommerce a.button:hover,
	.woocommerce button.button:hover,
	.woocommerce input.button:hover .woocommerce-mini-cart__buttons #respond input#submit:hover,
	.woocommerce-mini-cart__buttons a.button:hover,
	.woocommerce-mini-cart__buttons button.button:hover,
	.woocommerce-mini-cart__buttons input.button:hover,
	.woocommerce ul.products li.product .button.add_to_cart_button,
	.woocommerce #respond input#submit.alt,
	.woocommerce a.button.alt,
	.woocommerce button.button.alt,
	.woocommerce input.button.alt,
	.post-password-form input[type="submit"] {
		background-color: transparent!important;
	}
	<?php endif; ?>

	<?php if ( ! empty( $btn_height ) ) : ?>
	.tst-banner-sm form input,
	.woocommerce .quantity .qty,
	#add_payment_method table.cart td.actions .coupon .input-text,
	.woocommerce-cart table.cart td.actions .coupon .input-text,
	.woocommerce-checkout table.cart td.actions .coupon .input-text,
	.tst-btn,
	a.tst-btn,
	.tst-minicart-window .woocommerce-mini-cart__buttons a,
	.woocommerce-product-search button,
	.wp-block-button a.wp-block-button__link,
	.woocommerce #respond input#submit,
	.woocommerce a.button,
	.woocommerce button.button,
	.woocommerce input.button .woocommerce-mini-cart__buttons #respond input#submit,
	.woocommerce-mini-cart__buttons a.button,
	.woocommerce-mini-cart__buttons button.button,
	.woocommerce-mini-cart__buttons input.button,
	.woocommerce #respond input#submit:hover,
	.woocommerce a.button:hover,
	.woocommerce button.button:hover,
	.woocommerce input.button:hover .woocommerce-mini-cart__buttons #respond input#submit:hover,
	.woocommerce-mini-cart__buttons a.button:hover,
	.woocommerce-mini-cart__buttons button.button:hover,
	.woocommerce-mini-cart__buttons input.button:hover,
	.woocommerce ul.products li.product .button.add_to_cart_button,
	.woocommerce #respond input#submit.alt,
	.woocommerce a.button.alt,
	.woocommerce button.button.alt,
	.woocommerce input.button.alt,
	.post-password-form input[type="submit"] {
		height: <?php echo esc_attr( $btn_height ); ?>px;
		line-height: calc(<?php echo esc_attr( $btn_height ); ?>px - 2px);
	}
	<?php endif; ?>

	<?php if ( $preloader_bg_color ) : ?>
	/* Preloader BG Color */
	.tst-preloader-frame {
		background-color: <?php echo esc_attr( $preloader_bg_color ); ?>;
	}
	<?php endif; ?>

	<?php if ( $preloader_color ) : ?>
	/* Preloader Color */
	.tst-preloader-frame .tst-preloader span {
		border: 6px solid <?php echo esc_attr( $preloader_color ); ?> !important;
    border-top: 6px solid transparent !important;
	}
	<?php endif; ?>

	<?php if ( ! empty( $footer_bg_color ) ) : ?>
	/* Footer BG Color */
	footer.white-footer {
		background-color: <?php echo esc_attr( $footer_bg_color ); ?>;
	}
	<?php endif; ?>

	<?php if ( ! empty( $items_bg_color ) ) : ?>
	/* Items BG Color */
	.tst-menu-book-item,
	.tst-menu-book-item.tst-mbi-3,
	.tst-blog-card,
	.tst-team-member,
	.elementor-widget-tastyc-menu-simple .tst-menu-book-item .tst-menu-book-name h5 span,
	.elementor-widget-tastyc-menu-simple .tst-menu-book-item .tst-menu-book-descr .tst-menu-book-bottom .tst-menu-book-price .tst-price span,
	.woocommerce ul.products li.product,
	.woocommerce-page ul.products li.product,
	.ui-minimal .widget-area .product_list_widget li,
	.ui-minimal .tst-minicart-window .woocommerce-mini-cart .woocommerce-mini-cart-item,
	.ui-minimal .woocommerce table.shop_table,
	.tst-banner-sm .tst-wh-frame,
	.swiper-slide-active .tst-testimonial-card,
	.tst-pricing-box.marked,
	.tst-comment-box,
	.tst-minicart-window .woocommerce-mini-cart .woocommerce-mini-cart-item,
	.widget-area .product_list_widget li,
	.woocommerce table.shop_table,
	#add_payment_method #payment,
	.woocommerce-cart #payment,
	.woocommerce-checkout #payment,
	.swiper-pagination-bullet {
		background-color: <?php echo esc_attr( $items_bg_color ); ?>;
	}
	<?php endif; ?>

</style>

<?php
}
add_action( 'wp_head', 'tastyc_skin', 10 );
